/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimeoutListener;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.server.scheduler.Scheduler;

public class InfinispanTimer<I>
implements Timer<I> {
    private final TimerManager<I> manager;
    private final I id;
    private final ImmutableTimerMetaData metaData;
    private final Scheduler<I, ImmutableTimerMetaData> scheduler;
    private final TimeoutListener<I> listener;
    private final CacheEntryRemover<I> remover;
    private final TimerRegistry<I> registry;
    private volatile boolean canceled = false;

    public InfinispanTimer(TimerManager<I> manager, I id, ImmutableTimerMetaData metaData, Scheduler<I, ImmutableTimerMetaData> scheduler, TimeoutListener<I> listener, CacheEntryRemover<I> remover, TimerRegistry<I> registry) {
        this.manager = manager;
        this.id = id;
        this.metaData = metaData;
        this.scheduler = scheduler;
        this.listener = listener;
        this.remover = remover;
        this.registry = registry;
    }

    public I getId() {
        return this.id;
    }

    public ImmutableTimerMetaData getMetaData() {
        return this.metaData;
    }

    public boolean isActive() {
        return this.scheduler.contains(this.id);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.suspend();
        this.remove();
        this.canceled = true;
    }

    private void remove() {
        this.registry.unregister(this.id);
        this.remover.remove(this.id);
    }

    public void invoke() throws Exception {
        this.listener.timeout(this.manager, (Timer)this);
    }

    public void suspend() {
        this.scheduler.cancel(this.id);
    }

    public void activate() {
        if (!this.isActive()) {
            this.scheduler.schedule(this.id, (Object)this.metaData);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timer)) {
            return false;
        }
        return this.id.equals(((Timer)object).getId());
    }

    public String toString() {
        return this.id.toString();
    }
}

