/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.test.AssertionHelper;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class AssertSubscriber<T>
implements MultiSubscriber<T>,
ContextSupport {
    public static Duration DEFAULT_TIMEOUT = Duration.ofSeconds(Integer.parseInt(System.getenv().getOrDefault("DEFAULT_MUTINY_AWAIT_TIMEOUT", "10")));
    public static final String DEFAULT_MUTINY_AWAIT_TIMEOUT = "DEFAULT_MUTINY_AWAIT_TIMEOUT";
    private final CountDownLatch terminal = new CountDownLatch(1);
    private final CountDownLatch subscribed = new CountDownLatch(1);
    private volatile Flow.Subscription subscription = null;
    private final AtomicLong pendingRequests = new AtomicLong();
    private final List<T> items = new CopyOnWriteArrayList<T>();
    private volatile Throwable failure = null;
    private int numberOfSubscription = 0;
    private final boolean upfrontCancellation;
    private final Context context;
    private volatile State state = State.INIT;
    private final List<EventListener> eventListeners = new CopyOnWriteArrayList<EventListener>();

    public AssertSubscriber(Context context, long requested, boolean cancelled) {
        this.context = context;
        this.pendingRequests.set(requested);
        this.upfrontCancellation = cancelled;
    }

    public AssertSubscriber(long requested, boolean cancelled) {
        this(Context.empty(), requested, cancelled);
    }

    public AssertSubscriber() {
        this(Context.empty(), 0L, false);
    }

    public AssertSubscriber(long requested) {
        this(Context.empty(), requested, false);
    }

    public static <T> AssertSubscriber<T> create() {
        return new AssertSubscriber<T>(0L);
    }

    public static <T> AssertSubscriber<T> create(long requested) {
        return new AssertSubscriber<T>(requested);
    }

    public static <T> AssertSubscriber<T> create(Context context) {
        return new AssertSubscriber<T>(context, 0L, false);
    }

    public static <T> AssertSubscriber<T> create(Context context, long requested) {
        return new AssertSubscriber<T>(context, requested, false);
    }

    @Override
    public Context context() {
        return this.context;
    }

    public AssertSubscriber<T> assertCompleted() {
        AssertionHelper.shouldHaveCompleted(this.hasCompleted(), this.getFailure(), this.getItems());
        return this;
    }

    public AssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure, String expectedFailureMessage) {
        AssertionHelper.shouldHaveFailed(this.hasCompleted(), this.getFailure(), expectedTypeOfFailure, expectedFailureMessage);
        return this;
    }

    public AssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure) {
        AssertionHelper.shouldHaveFailed(this.hasCompleted(), this.getFailure(), expectedTypeOfFailure, null);
        return this;
    }

    public AssertSubscriber<T> assertHasNotReceivedAnyItem() {
        AssertionHelper.shouldHaveReceivedNoItems(this.items);
        return this;
    }

    public AssertSubscriber<T> assertSubscribed() {
        AssertionHelper.shouldBeSubscribed(this.numberOfSubscription);
        return this;
    }

    public AssertSubscriber<T> assertNotSubscribed() {
        AssertionHelper.shouldNotBeSubscribed(this.numberOfSubscription);
        return this;
    }

    public AssertSubscriber<T> assertTerminated() {
        AssertionHelper.shouldBeTerminated(this.hasCompleted(), this.getFailure());
        return this;
    }

    public AssertSubscriber<T> assertNotTerminated() {
        AssertionHelper.shouldNotBeTerminated(this.hasCompleted(), this.getFailure());
        return this;
    }

    @SafeVarargs
    public final AssertSubscriber<T> assertItems(T ... expected) {
        AssertionHelper.shouldHaveReceivedExactly(this.items, expected);
        return this;
    }

    public T getLastItem() {
        if (this.items.isEmpty()) {
            return null;
        }
        return this.items.get(this.items.size() - 1);
    }

    public AssertSubscriber<T> assertLastItem(T expected) {
        AssertionHelper.shouldHaveReceived(this.getLastItem(), expected);
        return this;
    }

    public AssertSubscriber<T> awaitNextItem() {
        return this.awaitNextItems(1);
    }

    public AssertSubscriber<T> awaitNextItem(Duration duration) {
        return this.awaitNextItems(1, 1, duration);
    }

    public AssertSubscriber<T> awaitNextItems(int number) {
        return this.awaitNextItems(number, DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitNextItems(int number, int request) {
        return this.awaitNextItems(number, request, DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitNextItems(int number, Duration duration) {
        return this.awaitNextItems(number, number, duration);
    }

    public AssertSubscriber<T> awaitNextItems(int number, int request, Duration duration) {
        if (this.hasCompleted() || this.getFailure() != null) {
            if (this.hasCompleted()) {
                throw new AssertionError((Object)"Expecting a next items, but a completion event has already being received");
            }
            throw new AssertionError((Object)("Expecting a next items, but a failure event has already being received: " + this.getFailure()));
        }
        this.awaitNextItemEvents(number, request, duration);
        return this;
    }

    public AssertSubscriber<T> awaitItems(int number) {
        return this.awaitItems(number, DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitItems(int number, Duration duration) {
        if (this.items.size() > number) {
            throw new AssertionError((Object)("Expected the number of items to be " + number + ", but it's already " + this.items.size()));
        }
        if (this.isCancelled() || this.hasCompleted() || this.getFailure() != null) {
            if (this.items.size() != number) {
                throw new AssertionError((Object)("Expected the number of items to be " + number + ", but received " + this.items.size() + " and we received a terminal event already"));
            }
            return this;
        }
        this.awaitItemEvents(number, duration);
        return this;
    }

    public AssertSubscriber<T> awaitCompletion() {
        return this.awaitCompletion(DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitCompletion(Duration duration) {
        try {
            this.awaitEvent(this.terminal, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("No completion (or failure) event received in the last " + duration.toMillis() + " ms"));
        }
        if (this.state == State.COMPLETED) {
            return this;
        }
        if (this.failure != null) {
            throw new AssertionError((Object)("Expected a completion event but got a failure: " + this.failure));
        }
        return this;
    }

    public AssertSubscriber<T> awaitFailure() {
        return this.awaitFailure((Throwable t) -> {});
    }

    public AssertSubscriber<T> awaitFailure(Consumer<Throwable> assertion) {
        return this.awaitFailure(assertion, DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitFailure(Duration duration) {
        return this.awaitFailure(t -> {}, duration);
    }

    public AssertSubscriber<T> awaitFailure(Consumer<Throwable> assertion, Duration duration) {
        try {
            this.awaitEvent(this.terminal, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("No completion (or failure) event received in the last " + duration.toMillis() + " ms"));
        }
        if (this.state == State.COMPLETED) {
            throw new AssertionError((Object)"Expected a failure event but got a completion event.");
        }
        try {
            assertion.accept(this.failure);
            return this;
        }
        catch (AssertionError e) {
            throw new AssertionError("Received a failure event, but that failure did not pass the validation: " + e, (Throwable)((Object)e));
        }
    }

    public AssertSubscriber<T> awaitSubscription() {
        return this.awaitSubscription(DEFAULT_TIMEOUT);
    }

    public AssertSubscriber<T> awaitSubscription(Duration duration) {
        try {
            this.awaitEvent(this.subscribed, duration);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("Expecting a subscription event in the last " + duration.toMillis() + " ms, but did not get it"));
        }
        return this;
    }

    private void awaitEvent(CountDownLatch latch, Duration duration) throws TimeoutException {
        if (latch.getCount() == 0L) {
            return;
        }
        try {
            if (!latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void awaitNextItemEvents(int number, int request, Duration duration) {
        NextItemTask task = new NextItemTask(number, this);
        CompletableFuture<Void> future = task.future();
        if (request > 0) {
            this.request(request);
        }
        int size = this.items.size();
        try {
            future.get(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            int received = this.items.size() - size;
            if (this.isCancelled()) {
                throw new AssertionError((Object)("Expected " + number + " items, but received a cancellation event while waiting. Only " + received + " item(s) have been received."));
            }
            if (this.hasCompleted()) {
                throw new AssertionError((Object)("Expected " + number + " items, but received a completion event while waiting. Only " + received + " item(s) have been received."));
            }
            throw new AssertionError((Object)("Expected " + number + " items, but received a failure event while waiting: " + this.getFailure() + ". Only " + received + " item(s) have been received."));
        }
        catch (TimeoutException e) {
            int received = this.items.size() - size;
            throw new AssertionError((Object)("Expected " + number + " items in " + duration.toMillis() + " ms, but only received " + received + " items."));
        }
    }

    private void awaitItemEvents(int expected, Duration duration) {
        ItemTask task = new ItemTask(expected, duration.toMillis(), this);
        try {
            task.future().get(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (expected == this.items.size()) {
                return;
            }
            if (this.isCancelled()) {
                throw new AssertionError((Object)("Expected " + expected + " items, but received a cancellation event while waiting. Only " + this.items.size() + " items have been received."));
            }
            if (this.hasCompleted()) {
                throw new AssertionError((Object)("Expected " + expected + " items, but received a completion event while waiting. Only " + this.items.size() + " items have been received."));
            }
            if (this.getFailure() != null) {
                throw new AssertionError((Object)("Expected " + expected + " items, but received a failure event while waiting: " + this.getFailure() + ". Only " + this.items.size() + " items have been received."));
            }
            e.printStackTrace();
            throw new AssertionError((Object)("Expected " + expected + " items.  Only " + this.items.size() + " items have been received."));
        }
        catch (TimeoutException e) {
            if (this.items.size() >= expected) {
                return;
            }
            throw new AssertionError((Object)("Expected " + expected + " items.  Only " + this.items.size() + " items have been received."));
        }
    }

    public AssertSubscriber<T> cancel() {
        AssertionHelper.shouldBeSubscribed(this.numberOfSubscription);
        this.subscription.cancel();
        this.state = State.CANCELLED;
        Event ev = new Event(null, null, false, true);
        this.eventListeners.forEach(l -> l.accept(ev));
        return this;
    }

    public synchronized AssertSubscriber<T> request(long req) {
        Subscriptions.add(this.pendingRequests, req);
        if (this.state != State.INIT) {
            this.subscription.request(req);
        }
        return this;
    }

    @Override
    public synchronized void onSubscribe(Flow.Subscription s) {
        ++this.numberOfSubscription;
        this.subscription = s;
        this.state = State.SUBSCRIBED;
        this.subscribed.countDown();
        if (this.upfrontCancellation) {
            s.cancel();
            this.state = State.CANCELLED;
            return;
        }
        long pending = this.pendingRequests.get();
        if (pending > 0L) {
            s.request(pending);
        }
    }

    @Override
    public synchronized void onItem(T t) {
        this.items.add(t);
        Event ev = new Event(t, null, false, false);
        this.eventListeners.forEach(l -> l.accept(ev));
        this.pendingRequests.decrementAndGet();
    }

    @Override
    public void onFailure(Throwable t) {
        this.state = State.FAILED;
        this.failure = t;
        this.terminal.countDown();
        Event ev = new Event(null, t, false, false);
        this.eventListeners.forEach(l -> l.accept(ev));
    }

    @Override
    public void onCompletion() {
        this.state = State.COMPLETED;
        this.terminal.countDown();
        Event ev = new Event(null, null, true, false);
        this.eventListeners.forEach(l -> l.accept(ev));
    }

    public List<T> getItems() {
        return this.items;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public AssertSubscriber<T> run(Runnable action) {
        try {
            action.run();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    public boolean hasCompleted() {
        return this.state == State.COMPLETED;
    }

    private void registerListener(EventListener listener) {
        this.eventListeners.add(listener);
    }

    private void unregisterListener(EventListener listener) {
        this.eventListeners.remove(listener);
    }

    private static class ItemTask<T> {
        private final int expected;
        private final AssertSubscriber<T> subscriber;
        private final long duration;

        public ItemTask(int expected, long duration, AssertSubscriber<T> subscriber) {
            this.expected = expected;
            this.subscriber = subscriber;
            this.duration = duration;
        }

        public CompletableFuture<Void> future() {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            long timeout = System.currentTimeMillis() + this.duration;
            new Thread(() -> {
                while (System.currentTimeMillis() < timeout) {
                    if (this.subscriber.items.size() >= this.expected) {
                        future.complete(null);
                        return;
                    }
                    if (this.subscriber.isCancelled() || this.subscriber.getFailure() != null || this.subscriber.hasCompleted()) {
                        future.completeExceptionally(new NoSuchElementException("Received a terminal event while waiting for items"));
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                future.completeExceptionally(new TimeoutException());
            }).start();
            return future;
        }
    }

    private static class NextItemTask<T> {
        private final int expected;
        private final AssertSubscriber<T> subscriber;

        public NextItemTask(int expected, AssertSubscriber<T> subscriber) {
            this.expected = expected;
            this.subscriber = subscriber;
        }

        public CompletableFuture<Void> future() {
            CompletableFuture future = new CompletableFuture();
            AtomicInteger count = new AtomicInteger(this.expected);
            EventListener listener = event -> {
                if (event.isItem()) {
                    if (count.decrementAndGet() == 0) {
                        future.complete(null);
                    }
                } else if (event.isCancellation() || event.isFailure() || event.isCompletion()) {
                    future.completeExceptionally(new NoSuchElementException("Received a terminal event while waiting for items"));
                }
            };
            this.subscriber.registerListener(listener);
            return future.whenComplete((x, f) -> this.subscriber.unregisterListener(listener));
        }
    }

    private static class Event {
        private final Object item;
        private final Throwable failure;
        private final boolean completion;
        private final boolean cancellation;

        private Event(Object item, Throwable failure, boolean completion, boolean cancellation) {
            this.item = item;
            this.failure = failure;
            this.completion = completion;
            this.cancellation = cancellation;
        }

        public boolean isItem() {
            return this.item != null;
        }

        public boolean isCancellation() {
            return this.cancellation;
        }

        public boolean isFailure() {
            return this.failure != null;
        }

        public boolean isCompletion() {
            return this.completion;
        }
    }

    private static interface EventListener
    extends Consumer<Event> {
    }

    private static enum State {
        INIT,
        SUBSCRIBED,
        FAILED,
        CANCELLED,
        COMPLETED;

    }
}

