/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.wildfly.core.instmgr.logging.InstMgrLogger;

class InstMgrCandidateStatus {
    private Path properties;
    public static final String INST_MGR_STATUS_KEY = "INST_MGR_STATUS";
    public static final String INST_MGR_COMMAND_KEY = "INST_MGR_COMMAND";

    InstMgrCandidateStatus() {
    }

    void initialize(Path properties) {
        this.properties = properties.normalize().toAbsolutePath();
    }

    Status getStatus() throws IOException {
        try (FileInputStream in = new FileInputStream(this.properties.toString());){
            Properties prop = new Properties();
            prop.load(in);
            String current = (String)prop.get(INST_MGR_STATUS_KEY);
            current = current == null ? "CLEAN" : current.trim();
            Status status = Status.valueOf(current);
            return status;
        }
    }

    void begin() throws IOException {
        this.setStatus(Status.PREPARING);
    }

    void reset() throws IOException {
        this.setStatus(Status.CLEAN);
    }

    void setFailed() throws IOException {
        this.setStatus(Status.ERROR);
    }

    void commit(String command) throws IOException {
        this.setStatus(Status.PREPARED, command);
    }

    private void setStatus(Status status) throws IOException {
        this.setStatus(status, "");
    }

    private void setStatus(Status status, String command) throws IOException {
        InstMgrLogger.ROOT_LOGGER.debugf("Setting Installation Manager Status to %s and command %s", status.name(), command);
        Properties prop = new Properties();
        if (status != Status.CLEAN) {
            try (FileInputStream in = new FileInputStream(this.properties.toString());){
                prop.load(in);
            }
        }
        try (FileOutputStream out = new FileOutputStream(this.properties.toString());){
            prop.setProperty(INST_MGR_COMMAND_KEY, command);
            prop.setProperty(INST_MGR_STATUS_KEY, status.name());
            prop.store(out, null);
        }
    }

    public static enum Status {
        ERROR,
        CLEAN,
        PREPARING,
        PREPARED;

    }
}

