/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.security.AdvancedSecurityMetaData;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.version.Stability;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.oidc.CredentialDefinition;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc.RedirectRewriteRuleDefinition;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.http.oidc.OidcClientConfigurationBuilder;
import org.wildfly.security.http.oidc.OidcClientContext;
import org.wildfly.security.http.oidc.OidcMechanismFactory;
import org.wildfly.security.http.oidc.OidcSecurityRealm;

class SecureDeploymentDefinition
extends SimpleResourceDefinition {
    static final ResourceRegistration PATH = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"secure-deployment"), (Stability)Stability.DEFAULT);
    protected static List<SimpleAttributeDefinition> NON_DEFAULT_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    protected static final SimpleAttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition RESOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"client-id"})).build();
    protected static final SimpleAttributeDefinition CLIENT_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-id", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"resource"})).build();
    protected static final SimpleAttributeDefinition SCOPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scope", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).setStability(Stability.PREVIEW)).build();
    protected static final SimpleAttributeDefinition USE_RESOURCE_ROLE_MAPPINGS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-resource-role-mappings", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition BEARER_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bearer-only", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition ENABLE_BASIC_AUTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-basic-auth", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition PUBLIC_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-client", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition TURN_OFF_CHANGE_SESSION_ID_ON_LOGIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("turn-off-change-session-id-on-login", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final SimpleAttributeDefinition TOKEN_MINIMUM_TIME_TO_LIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-minimum-time-to-live", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MIN_TIME_BETWEEN_JWKS_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-time-between-jwks-requests", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition PUBLIC_KEY_CACHE_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("public-key-cache-ttl", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition ADAPTER_STATE_COOKIE_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("adapter-state-cookie-path", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    static final List<SimpleAttributeDefinition> ALL_ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();
    private static final String WAR_FILE_EXTENSION = ".war";

    SecureDeploymentDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, ElytronOidcExtension.getResourceDescriptionResolver("secure-deployment")).setAddHandler((OperationStepHandler)SecureDeploymentAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)SecureDeploymentRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
        NON_DEFAULT_ATTRIBUTES.add(SCOPE);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.AUTHENTICATION_REQUEST_FORMAT);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_ENCRYPTION_ENC_VALUE);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_ENCRYPTION_ALG_VALUE);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_KEYSTORE_FILE);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_KEY_ALIAS);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_KEY_PASSWORD);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_KEYSTORE_PASSWORD);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_KEYSTORE_TYPE);
        NON_DEFAULT_ATTRIBUTES.add(ProviderAttributeDefinitions.REQUEST_OBJECT_SIGNING_ALGORITHM);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attributeDefinition : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, (OperationStepHandler)SecureDeploymentWriteAttributeHandler.INSTANCE);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new CredentialDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new RedirectRewriteRuleDefinition());
    }

    static boolean isWarDeployment(OperationContext context) {
        return context.getCurrentAddressValue().endsWith(WAR_FILE_EXTENSION);
    }

    static {
        ALL_ATTRIBUTES.add(REALM);
        ALL_ATTRIBUTES.add(PROVIDER);
        ALL_ATTRIBUTES.add(RESOURCE);
        ALL_ATTRIBUTES.add(CLIENT_ID);
        ALL_ATTRIBUTES.add(USE_RESOURCE_ROLE_MAPPINGS);
        ALL_ATTRIBUTES.add(BEARER_ONLY);
        ALL_ATTRIBUTES.add(ENABLE_BASIC_AUTH);
        ALL_ATTRIBUTES.add(PUBLIC_CLIENT);
        ALL_ATTRIBUTES.add(TURN_OFF_CHANGE_SESSION_ID_ON_LOGIN);
        ALL_ATTRIBUTES.add(TOKEN_MINIMUM_TIME_TO_LIVE);
        ALL_ATTRIBUTES.add(MIN_TIME_BETWEEN_JWKS_REQUESTS);
        ALL_ATTRIBUTES.add(PUBLIC_KEY_CACHE_TTL);
        ALL_ATTRIBUTES.add(ADAPTER_STATE_COOKIE_PATH);
        ALL_ATTRIBUTES.add((SimpleAttributeDefinition)CredentialDefinition.CREDENTIAL);
        ALL_ATTRIBUTES.add(SCOPE);
        ALL_ATTRIBUTES.add((SimpleAttributeDefinition)RedirectRewriteRuleDefinition.REDIRECT_REWRITE_RULE);
        for (SimpleAttributeDefinition attribute : ProviderAttributeDefinitions.ATTRIBUTES) {
            ALL_ATTRIBUTES.add(attribute);
        }
    }

    static class SecureDeploymentAddHandler
    extends AbstractAddStepHandler {
        public static SecureDeploymentAddHandler INSTANCE = new SecureDeploymentAddHandler();

        private SecureDeploymentAddHandler() {
            super(ALL_ATTRIBUTES);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            if (!SecureDeploymentDefinition.isWarDeployment(context)) {
                VirtualDomainMarkerUtility.virtualDomainRequired((OperationContext)context);
                AdvancedSecurityMetaData advancedSecurityMetaData = new AdvancedSecurityMetaData();
                advancedSecurityMetaData.setHttpServerAuthenticationMechanismFactory(VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryName((OperationContext)context));
                advancedSecurityMetaData.setSecurityDomain(VirtualDomainMarkerUtility.virtualDomainName((OperationContext)context));
                context.attach(SecurityMetaData.OPERATION_CONTEXT_ATTACHMENT_KEY, (Object)advancedSecurityMetaData);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String clientId = CLIENT_ID.resolveModelAttribute(context, model).asStringOrNull();
            String resource = RESOURCE.resolveModelAttribute(context, model).asStringOrNull();
            if (clientId == null && resource == null) {
                throw ElytronOidcLogger.ROOT_LOGGER.resourceOrClientIdMustBeConfigured();
            }
            boolean disableTrustManager = ProviderAttributeDefinitions.DISABLE_TRUST_MANAGER.resolveModelAttribute(context, model).asBoolean();
            if (disableTrustManager) {
                ElytronOidcLogger.ROOT_LOGGER.disableTrustManagerSetToTrue();
            }
            String secureDeploymentName = context.getCurrentAddressValue();
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addSecureDeployment(secureDeploymentName, context.resolveExpressions(model));
            if (!SecureDeploymentDefinition.isWarDeployment(context)) {
                ServiceTarget serviceTarget = context.getServiceTarget();
                ServiceName virtualMechanismFactoryName = VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryName((OperationContext)context);
                ServiceBuilder serviceBuilder = serviceTarget.addService(virtualMechanismFactoryName);
                OidcClientContext oidcClientContext = new OidcClientContext(OidcClientConfigurationBuilder.build((InputStream)new ByteArrayInputStream(oidcConfigService.getJSON(secureDeploymentName).getBytes())));
                OidcMechanismFactory virtualMechanismFactory = new OidcMechanismFactory(oidcClientContext);
                Consumer mechanismFactoryConsumer = serviceBuilder.provides(new ServiceName[]{virtualMechanismFactoryName});
                serviceBuilder.setInstance(Service.newInstance((Consumer)mechanismFactoryConsumer, (Object)virtualMechanismFactory));
                serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
                serviceBuilder.install();
                ServiceName virtualDomainName = VirtualDomainMarkerUtility.virtualDomainName((OperationContext)context);
                serviceBuilder = serviceTarget.addService(virtualDomainName);
                SecurityDomain virtualDomain = SecurityDomain.builder().addRealm("virtual", (SecurityRealm)new OidcSecurityRealm()).build().setDefaultRealmName("virtual").setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
                Consumer securityDomainConsumer = serviceBuilder.provides(new ServiceName[]{virtualDomainName});
                serviceBuilder.setInstance(Service.newInstance((Consumer)securityDomainConsumer, (Object)virtualDomain));
                serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
                serviceBuilder.install();
                if (!context.isBooting()) {
                    context.reloadRequired();
                }
            }
        }
    }

    static class SecureDeploymentRemoveHandler
    extends AbstractRemoveStepHandler {
        public static SecureDeploymentRemoveHandler INSTANCE = new SecureDeploymentRemoveHandler();

        SecureDeploymentRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeSecureDeployment(context.getCurrentAddressValue());
            if (!SecureDeploymentDefinition.isWarDeployment(context)) {
                context.reloadRequired();
            }
        }
    }

    static class SecureDeploymentWriteAttributeHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final SecureDeploymentWriteAttributeHandler INSTANCE = new SecureDeploymentWriteAttributeHandler();

        SecureDeploymentWriteAttributeHandler() {
            super((AttributeDefinition[])ALL_ATTRIBUTES.toArray(new SimpleAttributeDefinition[ALL_ATTRIBUTES.size()]));
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateSecureDeployment(context.getCurrentAddressValue(), attributeName, resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return !SecureDeploymentDefinition.isWarDeployment(context);
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateSecureDeployment(context.getCurrentAddressValue(), attributeName, valueToRestore);
        }
    }
}

