/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.AdvancedSecurityMetaData;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.server.security.VirtualDomainUtil;
import org.jboss.as.web.common.VirtualHttpServerMechanismFactoryMarkerUtility;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.msc.service.ServiceName;

public class VirtualHttpServerMechanismFactoryNameProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        LoginConfigMetaData loginConfig = warMetaData.getMergedJBossWebMetaData().getLoginConfig();
        SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
        if (securityMetaData != null && loginConfig != null && "OIDC".equals(loginConfig.getAuthMethod()) && VirtualHttpServerMechanismFactoryMarkerUtility.isVirtualMechanismFactoryRequired((DeploymentUnit)deploymentUnit)) {
            AdvancedSecurityMetaData advancedSecurityMetaData = new AdvancedSecurityMetaData();
            advancedSecurityMetaData.setHttpServerAuthenticationMechanismFactory(VirtualHttpServerMechanismFactoryMarkerUtility.virtualMechanismFactoryName((DeploymentUnit)deploymentUnit));
            ServiceName virtualDomainName = VirtualDomainMarkerUtility.virtualDomainName((DeploymentUnit)deploymentUnit);
            advancedSecurityMetaData.setSecurityDomain(virtualDomainName);
            deploymentUnit.putAttachment(SecurityMetaData.ATTACHMENT_KEY, (Object)advancedSecurityMetaData);
            VirtualDomainUtil.setTopLevelDeploymentSecurityMetaData((DeploymentUnit)deploymentUnit, (ServiceName)virtualDomainName);
        }
    }
}

