/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.Functions;

public interface Installer<ST extends ServiceTarget> {
    public ServiceController<?> install(ST var1);

    public static class UnaryService<T, V>
    implements Service {
        private final Consumer<V> captor;
        private final Function<T, V> mapper;
        private final Supplier<T> factory;
        private final Consumer<T> startTask;
        private final Consumer<T> stopTask;
        private volatile T value;

        UnaryService(Consumer<V> captor, Function<T, V> mapper, Supplier<T> factory, Consumer<T> startTask, Consumer<T> stopTask) {
            this.captor = captor;
            this.mapper = mapper;
            this.factory = factory;
            this.startTask = startTask;
            this.stopTask = stopTask;
        }

        public void start(StartContext context) throws StartException {
            this.value = this.factory.get();
            this.startTask.accept(this.value);
            this.captor.accept(this.mapper.apply(this.value));
        }

        public void stop(StopContext context) {
            try {
                this.stopTask.accept(this.value);
            }
            finally {
                this.value = null;
                this.captor.accept(null);
            }
        }
    }

    public static abstract class AbstractUnaryBuilder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>, T, V>
    extends AbstractBuilder<B, I, ST, SB, DSB>
    implements UnaryBuilder<B, I, ST, DSB, T, V>,
    Function<SB, Service> {
        private final List<ServiceName> names = new LinkedList<ServiceName>();
        private final Function<T, V> mapper;
        private final Supplier<T> factory;
        private final BiFunction<SB, Collection<ServiceName>, Consumer<V>> provider;
        private volatile Consumer<V> captor = Functions.discardingConsumer();
        private volatile Consumer<T> startTask = Functions.discardingConsumer();
        private volatile Consumer<T> stopTask = Functions.discardingConsumer();

        protected AbstractUnaryBuilder(Function<T, V> mapper, Supplier<T> factory) {
            this(mapper, factory, new BiFunction<SB, Collection<ServiceName>, Consumer<V>>(){

                @Override
                public Consumer<V> apply(SB builder, Collection<ServiceName> names) {
                    return !names.isEmpty() ? builder.provides((ServiceName[])names.toArray(ServiceName[]::new)) : Functions.discardingConsumer();
                }
            });
        }

        protected AbstractUnaryBuilder(Function<T, V> mapper, Supplier<T> factory, BiFunction<SB, Collection<ServiceName>, Consumer<V>> provider) {
            this.mapper = mapper;
            this.factory = factory;
            this.provider = provider;
        }

        @Override
        public B provides(ServiceName name) {
            this.names.add(name);
            return this.builder();
        }

        @Override
        public B withCaptor(Consumer<V> captor) {
            this.captor = AbstractUnaryBuilder.compose(this.captor, captor);
            return this.builder();
        }

        @Override
        public B onStart(Consumer<T> task) {
            this.startTask = AbstractUnaryBuilder.compose(this.startTask, task);
            return this.builder();
        }

        @Override
        public B onStop(Consumer<T> task) {
            this.stopTask = AbstractUnaryBuilder.compose(this.stopTask, task);
            return this.builder();
        }

        private static <X> boolean isDefined(Consumer<X> task) {
            return task != Functions.discardingConsumer();
        }

        private static <X> Consumer<X> compose(Consumer<X> currentTask, Consumer<X> newTask) {
            return AbstractUnaryBuilder.isDefined(currentTask) ? currentTask.andThen(newTask) : newTask;
        }

        @Override
        public Function<SB, Service> getServiceFactory() {
            return this;
        }

        @Override
        public Service apply(SB builder) {
            Consumer<V> injector = this.provider.apply(builder, this.names);
            Consumer<V> captor = this.captor;
            if (AbstractUnaryBuilder.isDefined(captor)) {
                injector = AbstractUnaryBuilder.isDefined(injector) ? injector.andThen(captor) : captor;
            }
            return new UnaryService<T, V>(injector, this.mapper, this.factory, this.startTask, this.stopTask);
        }

        protected boolean hasStopTask() {
            return AbstractUnaryBuilder.isDefined(this.stopTask);
        }
    }

    public static abstract class AbstractNullaryBuilder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>>
    extends AbstractBuilder<B, I, ST, SB, DSB>
    implements Function<SB, Service> {
        private final Service service;

        protected AbstractNullaryBuilder(Service service) {
            this.service = service;
        }

        @Override
        public Function<SB, Service> getServiceFactory() {
            return this;
        }

        @Override
        public Service apply(SB builder) {
            return this.service;
        }
    }

    public static abstract class AbstractBuilder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>>
    implements Builder<B, I, ST, DSB>,
    Configuration<SB, DSB> {
        private volatile ServiceController.Mode mode = ServiceController.Mode.ON_DEMAND;
        private volatile Consumer<DSB> dependency = Functions.discardingConsumer();

        protected abstract B builder();

        @Override
        public B asPassive() {
            this.mode = ServiceController.Mode.PASSIVE;
            return this.builder();
        }

        @Override
        public B asActive() {
            this.mode = ServiceController.Mode.ACTIVE;
            return this.builder();
        }

        @Override
        public B requires(Consumer<DSB> dependency) {
            this.dependency = this.dependency == Functions.discardingConsumer() ? dependency : this.dependency.andThen(dependency);
            return this.builder();
        }

        @Override
        public ServiceController.Mode getInitialMode() {
            return this.mode;
        }

        @Override
        public Consumer<DSB> getDependency() {
            return this.dependency;
        }
    }

    public static class DefaultInstaller<ST extends ServiceTarget, SB extends DSB, DSB extends ServiceBuilder<?>>
    implements Installer<ST> {
        private final Function<ST, SB> serviceBuilderFactory;
        private final ServiceController.Mode mode;
        private final Consumer<DSB> dependency;
        private final Function<SB, Service> serviceFactory;

        protected DefaultInstaller(Configuration<SB, DSB> config, Function<ST, SB> serviceBuilderFactory) {
            this.serviceBuilderFactory = serviceBuilderFactory;
            this.serviceFactory = config.getServiceFactory();
            this.mode = config.getInitialMode();
            this.dependency = config.getDependency();
        }

        @Override
        public ServiceController<?> install(ST target) {
            ServiceBuilder builder = (ServiceBuilder)this.serviceBuilderFactory.apply(target);
            this.dependency.accept(builder);
            return builder.setInstance(this.serviceFactory.apply(builder)).setInitialMode(this.mode).install();
        }
    }

    public static interface Configuration<SB extends DSB, DSB extends ServiceBuilder<?>> {
        public ServiceController.Mode getInitialMode();

        public Consumer<DSB> getDependency();

        public Function<SB, Service> getServiceFactory();
    }

    public static interface UnaryBuilder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends ServiceBuilder<?>, T, V>
    extends Builder<B, I, ST, SB> {
        public B provides(ServiceName var1);

        public B withCaptor(Consumer<V> var1);

        public B onStart(Consumer<T> var1);

        public B onStop(Consumer<T> var1);
    }

    public static interface BlockingBuilder<B> {
        public B blocking();
    }

    public static interface Builder<B, I extends Installer<ST>, ST extends ServiceTarget, SB extends ServiceBuilder<?>> {
        public B requires(Consumer<SB> var1);

        default public B requires(final Iterable<? extends Consumer<SB>> dependencies) {
            return this.requires(new Consumer<SB>(){

                @Override
                public void accept(SB builder) {
                    for (Consumer dependency : dependencies) {
                        dependency.accept(builder);
                    }
                }
            });
        }

        public B asPassive();

        public B asActive();

        public I build();
    }
}

