/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevCommit;

public class PlotCommit<L extends PlotLane>
extends RevCommit {
    static final PlotCommit[] NO_CHILDREN = new PlotCommit[0];
    static final PlotLane[] NO_LANES = new PlotLane[0];
    static final Ref[] NO_REFS = new Ref[0];
    PlotLane[] forkingOffLanes = NO_LANES;
    PlotLane[] passingLanes = NO_LANES;
    PlotLane[] mergingLanes = NO_LANES;
    PlotLane lane;
    PlotCommit[] children = NO_CHILDREN;
    Ref[] refs = NO_REFS;

    protected PlotCommit(AnyObjectId id) {
        super(id);
    }

    void addForkingOffLane(PlotLane f) {
        this.forkingOffLanes = PlotCommit.addLane(f, this.forkingOffLanes);
    }

    void addPassingLane(PlotLane c) {
        this.passingLanes = PlotCommit.addLane(c, this.passingLanes);
    }

    void addMergingLane(PlotLane m) {
        this.mergingLanes = PlotCommit.addLane(m, this.mergingLanes);
    }

    private static PlotLane[] addLane(PlotLane l, PlotLane[] lanes) {
        int cnt = lanes.length;
        switch (cnt) {
            case 0: {
                lanes = new PlotLane[]{l};
                break;
            }
            case 1: {
                lanes = new PlotLane[]{lanes[0], l};
                break;
            }
            default: {
                PlotLane[] n = new PlotLane[cnt + 1];
                System.arraycopy(lanes, 0, n, 0, cnt);
                n[cnt] = l;
                lanes = n;
            }
        }
        return lanes;
    }

    void addChild(PlotCommit c) {
        int cnt = this.children.length;
        switch (cnt) {
            case 0: {
                this.children = new PlotCommit[]{c};
                break;
            }
            case 1: {
                if (c.getId().equals(this.children[0].getId())) break;
                this.children = new PlotCommit[]{this.children[0], c};
                break;
            }
            default: {
                PlotCommit[] plotCommitArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    PlotCommit pc = plotCommitArray[n2];
                    if (c.getId().equals(pc.getId())) {
                        return;
                    }
                    ++n2;
                }
                PlotCommit[] n3 = new PlotCommit[cnt + 1];
                System.arraycopy(this.children, 0, n3, 0, cnt);
                n3[cnt] = c;
                this.children = n3;
            }
        }
    }

    public final int getChildCount() {
        return this.children.length;
    }

    public final PlotCommit getChild(int nth) {
        return this.children[nth];
    }

    public final boolean isChild(PlotCommit c) {
        PlotCommit[] plotCommitArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            PlotCommit a = plotCommitArray[n2];
            if (a == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final int getRefCount() {
        return this.refs.length;
    }

    public final Ref getRef(int nth) {
        return this.refs[nth];
    }

    public final L getLane() {
        return (L)this.lane;
    }

    @Override
    public void reset() {
        this.forkingOffLanes = NO_LANES;
        this.passingLanes = NO_LANES;
        this.mergingLanes = NO_LANES;
        this.children = NO_CHILDREN;
        this.lane = null;
        super.reset();
    }
}

