/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class BackupConfiguration
extends ConfigurationElement<BackupConfiguration> {
    public static final AttributeDefinition<String> SITE = AttributeDefinition.builder((Enum)Attribute.SITE, null, String.class).autoPersist(false).immutable().build();
    public static final AttributeDefinition<BackupStrategy> STRATEGY = AttributeDefinition.builder((Enum)Attribute.STRATEGY, (Object)((Object)BackupStrategy.ASYNC)).immutable().build();
    public static final AttributeDefinition<Long> REPLICATION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.TIMEOUT, (Object)15000L).build();
    public static final AttributeDefinition<BackupFailurePolicy> FAILURE_POLICY = AttributeDefinition.builder((Enum)Attribute.BACKUP_FAILURE_POLICY, (Object)((Object)BackupFailurePolicy.WARN)).build();
    public static final AttributeDefinition<String> FAILURE_POLICY_CLASS = AttributeDefinition.builder((Enum)Attribute.FAILURE_POLICY_CLASS, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> USE_TWO_PHASE_COMMIT = AttributeDefinition.builder((Enum)Attribute.USE_TWO_PHASE_COMMIT, (Object)false).immutable().build();
    private final TakeOfflineConfiguration takeOfflineConfiguration;
    private final XSiteStateTransferConfiguration xSiteStateTransferConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupConfiguration.class, Element.BACKUP.toString(), null, new AttributeDefinition[]{SITE, STRATEGY, REPLICATION_TIMEOUT, FAILURE_POLICY, FAILURE_POLICY_CLASS, USE_TWO_PHASE_COMMIT}, new AttributeSet.RemovedAttribute[]{new AttributeSet.RemovedAttribute((Enum)Attribute.ENABLED, 15, 0)});
    }

    public BackupConfiguration(AttributeSet attributes, TakeOfflineConfiguration takeOfflineConfiguration, XSiteStateTransferConfiguration xSiteStateTransferConfiguration) {
        super((Enum)Element.BACKUP, attributes, new ConfigurationElement[]{takeOfflineConfiguration, xSiteStateTransferConfiguration});
        this.takeOfflineConfiguration = takeOfflineConfiguration;
        this.xSiteStateTransferConfiguration = xSiteStateTransferConfiguration;
    }

    public String site() {
        return (String)this.attributes.attribute(SITE).get();
    }

    public BackupStrategy strategy() {
        return (BackupStrategy)((Object)this.attributes.attribute(STRATEGY).get());
    }

    public TakeOfflineConfiguration takeOffline() {
        return this.takeOfflineConfiguration;
    }

    public String failurePolicyClass() {
        return (String)this.attributes.attribute(FAILURE_POLICY_CLASS).get();
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public boolean isSyncBackup() {
        return this.strategy() == BackupStrategy.SYNC;
    }

    public long replicationTimeout() {
        return (Long)this.attributes.attribute(REPLICATION_TIMEOUT).get();
    }

    @Deprecated(forRemoval=true)
    public BackupConfiguration replicationTimeout(long timeout) {
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return (BackupFailurePolicy)((Object)this.attributes.attribute(FAILURE_POLICY).get());
    }

    public boolean isTwoPhaseCommit() {
        return (Boolean)this.attributes.attribute(USE_TWO_PHASE_COMMIT).get();
    }

    @Deprecated(forRemoval=true)
    public boolean enabled() {
        return true;
    }

    public XSiteStateTransferConfiguration stateTransfer() {
        return this.xSiteStateTransferConfiguration;
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

