/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import org.infinispan.io.MarshalledValueByteStream;

@Deprecated(forRemoval=true)
public final class ExpandableMarshalledValueByteStream
extends MarshalledValueByteStream {
    private byte[] buf;
    private int count;
    public static final int DEFAULT_DOUBLING_SIZE = 0x400000;
    private int maxDoublingSize = 0x400000;

    public ExpandableMarshalledValueByteStream() {
        this(32);
    }

    public ExpandableMarshalledValueByteStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public ExpandableMarshalledValueByteStream(int size, int maxDoublingSize) {
        this(size);
        this.maxDoublingSize = maxDoublingSize;
    }

    @Override
    public final byte[] getRaw() {
        return this.buf;
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public final void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public final int getMaxDoublingSize() {
        return this.maxDoublingSize;
    }

    public final int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= this.maxDoublingSize) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }

    @Override
    public final int size() {
        return this.count;
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof MarshalledValueByteStream) {
            MarshalledValueByteStream that = (MarshalledValueByteStream)thatObject;
            if (this == that) {
                return true;
            }
            byte[] thoseBytes = that.getRaw();
            if (this.buf == thoseBytes) {
                return true;
            }
            if (this.count != that.size()) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.buf[i] == thoseBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

