/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static <T> T doPrivilegedException(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static boolean fileExists(File file) {
        return SecurityActions.doPrivileged(file::exists);
    }

    static boolean deleteFile(File file) {
        return SecurityActions.doPrivileged(file::delete);
    }

    static void moveFile(Path sourcePath, Path destPath, StandardCopyOption ... moveOptions) throws IOException {
        try {
            SecurityActions.doPrivilegedException(() -> Files.move(sourcePath, destPath, moveOptions));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new PersistenceException(e);
        }
    }

    static FileChannel openFileChannel(File file) throws FileNotFoundException {
        try {
            return SecurityActions.doPrivilegedException(() -> new RandomAccessFile(file, "rw").getChannel());
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getCause();
            }
            throw new PersistenceException(e);
        }
    }

    public static boolean createDirectoryIfNeeded(File dir) {
        return SecurityActions.doPrivileged(() -> dir.mkdirs() || dir.exists());
    }
}

