/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.jgroups.RequestTracker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleTargetRequest<T>
extends AbstractRequest<T> {
    private static final Log log = LogFactory.getLog(SingleTargetRequest.class);
    @GuardedBy(value="responseCollector")
    private RequestTracker requestTracker;

    public SingleTargetRequest(ResponseCollector<T> wrapper, long requestId, RequestRepository repository, RequestTracker requestTracker) {
        super(requestId, wrapper, repository);
        this.requestTracker = requestTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Address sender, Response response) {
        try {
            T result;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.requestTracker != null && !this.requestTracker.destination().equals(sender)) {
                    log.tracef("Received unexpected response to request %d from %s, target is %s", this.requestId, sender, this.requestTracker.destination());
                }
                result = this.addResponse(sender, response);
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewView(Set<Address> members) {
        try {
            T result;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.requestTracker == null || members.contains(this.requestTracker.destination())) {
                    return false;
                }
                result = this.addResponse(this.requestTracker.destination(), CacheNotFoundResponse.INSTANCE);
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return true;
    }

    @GuardedBy(value="responseCollector")
    private T addResponse(Address sender, Response response) {
        this.requestTracker.onComplete();
        this.requestTracker = null;
        Object result = this.responseCollector.addResponse(sender, response);
        if (result == null) {
            result = this.responseCollector.finish();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTimeout() {
        String targetString = null;
        ResponseCollector responseCollector = this.responseCollector;
        synchronized (responseCollector) {
            if (this.requestTracker != null) {
                this.requestTracker.onTimeout();
                targetString = this.requestTracker.destination().toString();
            }
        }
        this.completeExceptionally((Throwable)((Object)Log.CLUSTER.requestTimedOut(this.requestId, targetString, Util.prettyPrintTime((long)this.getTimeoutMs()))));
    }
}

