/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.Set;
import org.infinispan.commons.tx.Util;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfo;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
@MBean(objectName="RecoveryAdmin", description="Exposes tooling for handling transaction recovery.")
public class RecoveryAdminOperations {
    private static final Log log = LogFactory.getLog(RecoveryAdminOperations.class);
    private static final String SEPARATOR = ", ";
    @Inject
    RecoveryManager recoveryManager;

    @ManagedOperation(description="Shows all the prepared transactions for which the originating node crashed", displayName="Show in doubt transactions")
    public String showInDoubtTransactions() {
        Set<InDoubtTxInfo> info = this.getRecoveryInfoFromCluster();
        if (log.isTraceEnabled()) {
            log.tracef("Found in doubt transactions: %s", info.size());
        }
        StringBuilder result = new StringBuilder();
        for (InDoubtTxInfo i : info) {
            result.append("xid = [").append(i.getXid()).append("], ").append(SEPARATOR).append("internalId = ").append(i.getInternalId()).append(SEPARATOR);
            result.append("status = [ ");
            int status = i.getStatus();
            if (status != -1) {
                result.append(Util.transactionStatusToString((int)status));
            }
            result.append(" ]");
            result.append('\n');
        }
        return result.toString();
    }

    @ManagedOperation(description="Forces the commit of an in-doubt transaction", displayName="Force commit by internal id")
    public String forceCommit(@Parameter(name="internalId", description="The internal identifier of the transaction") long internalId) {
        if (log.isTraceEnabled()) {
            log.tracef("Forces the commit of an in-doubt transaction: %s", internalId);
        }
        return this.completeBasedOnInternalId(internalId, true);
    }

    @ManagedOperation(description="Forces the commit of an in-doubt transaction", displayName="Force commit by Xid", name="forceCommit")
    public String forceCommit(@Parameter(name="formatId", description="The formatId of the transaction") int formatId, @Parameter(name="globalTxId", description="The globalTxId of the transaction") byte[] globalTxId, @Parameter(name="branchQualifier", description="The branchQualifier of the transaction") byte[] branchQualifier) {
        return this.completeBasedOnXid(formatId, globalTxId, branchQualifier, true);
    }

    @ManagedOperation(description="Forces the rollback of an in-doubt transaction", displayName="Force rollback by internal id")
    public String forceRollback(@Parameter(name="internalId", description="The internal identifier of the transaction") long internalId) {
        return this.completeBasedOnInternalId(internalId, false);
    }

    @ManagedOperation(description="Forces the rollback of an in-doubt transaction", displayName="Force rollback by Xid", name="forceRollback")
    public String forceRollback(@Parameter(name="formatId", description="The formatId of the transaction") int formatId, @Parameter(name="globalTxId", description="The globalTxId of the transaction") byte[] globalTxId, @Parameter(name="branchQualifier", description="The branchQualifier of the transaction") byte[] branchQualifier) {
        return this.completeBasedOnXid(formatId, globalTxId, branchQualifier, false);
    }

    @ManagedOperation(description="Removes recovery info for the given transaction.", displayName="Remove recovery info by Xid", name="forget")
    public String forget(@Parameter(name="formatId", description="The formatId of the transaction") int formatId, @Parameter(name="globalTxId", description="The globalTxId of the transaction") byte[] globalTxId, @Parameter(name="branchQualifier", description="The branchQualifier of the transaction") byte[] branchQualifier) {
        CompletionStages.join(this.recoveryManager.removeRecoveryInformation(null, XidImpl.create((int)formatId, (byte[])globalTxId, (byte[])branchQualifier), null, false));
        return "Recovery info removed.";
    }

    @ManagedOperation(description="Removes recovery info for the given transaction.", displayName="Remove recovery info by internal id")
    public String forget(@Parameter(name="internalId", description="The internal identifier of the transaction") long internalId) {
        CompletionStages.join(this.recoveryManager.removeRecoveryInformationFromCluster(null, internalId));
        return "Recovery info removed.";
    }

    private String completeBasedOnXid(int formatId, byte[] globalTxId, byte[] branchQualifier, boolean commit) {
        InDoubtTxInfo inDoubtTxInfo = this.lookupRecoveryInfo(formatId, globalTxId, branchQualifier);
        if (inDoubtTxInfo != null) {
            return this.completeTransaction(inDoubtTxInfo, commit);
        }
        return this.transactionNotFound(formatId, globalTxId, branchQualifier);
    }

    private String completeBasedOnInternalId(long internalId, boolean commit) {
        InDoubtTxInfo inDoubtTxInfo = this.lookupRecoveryInfo(internalId);
        if (inDoubtTxInfo != null) {
            return this.completeTransaction(inDoubtTxInfo, commit);
        }
        return this.transactionNotFound(internalId);
    }

    private String completeTransaction(InDoubtTxInfo i, boolean commit) {
        if (i.isLocal()) {
            log.tracef("Forcing completion of local transaction: %s", i);
            return CompletionStages.join(this.recoveryManager.forceTransactionCompletion(i.getXid(), commit));
        }
        log.tracef("Forcing completion of remote transaction: %s", i);
        Set<Address> owners = i.getOwners();
        if (owners == null || owners.isEmpty()) {
            throw new IllegalStateException("Owner list cannot be empty for " + String.valueOf(i));
        }
        return this.recoveryManager.forceTransactionCompletionFromCluster(i.getXid(), owners.iterator().next(), commit);
    }

    private InDoubtTxInfo lookupRecoveryInfo(int formatId, byte[] globalTxId, byte[] branchQualifier) {
        Set<InDoubtTxInfo> info = this.getRecoveryInfoFromCluster();
        XidImpl xid = XidImpl.create((int)formatId, (byte[])globalTxId, (byte[])branchQualifier);
        for (InDoubtTxInfo i : info) {
            if (!i.getXid().equals((Object)xid)) continue;
            log.tracef("Found matching recovery info: %s", i);
            return i;
        }
        return null;
    }

    private Set<InDoubtTxInfo> getRecoveryInfoFromCluster() {
        Set<InDoubtTxInfo> info = this.recoveryManager.getInDoubtTransactionInfoFromCluster();
        log.tracef("Recovery info from cluster is: %s", info);
        return info;
    }

    private InDoubtTxInfo lookupRecoveryInfo(long internalId) {
        Set<InDoubtTxInfo> info = this.getRecoveryInfoFromCluster();
        for (InDoubtTxInfo i : info) {
            if (i.getInternalId() != internalId) continue;
            log.tracef("Found matching recovery info: %s", i);
            return i;
        }
        return null;
    }

    private String transactionNotFound(int formatId, byte[] globalTxId, byte[] branchQualifier) {
        return "Transaction not found: " + XidImpl.printXid((int)formatId, (byte[])globalTxId, (byte[])branchQualifier);
    }

    private String transactionNotFound(long internalId) {
        return "Transaction not found for internal id: " + internalId;
    }
}

