/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.PropertiesAttributeDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteThroughResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class StoreResourceDefinition<C extends StoreConfiguration, B extends StoreConfigurationBuilder<C, B>>
extends ComponentResourceDefinition
implements ResourceModelResolver<Map.Entry<Map.Entry<Supplier<B>, Consumer<B>>, Stream<Consumer<RequirementServiceBuilder<?>>>>> {
    protected static final PathElement WILDCARD_PATH = StoreResourceDefinition.pathElement("*");
    static final BinaryServiceDescriptor<PersistenceConfiguration> SERVICE_DESCRIPTOR = StoreResourceDefinition.serviceDescriptor(WILDCARD_PATH, PersistenceConfiguration.class);
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();
    static final Set<PathElement> REQUIRED_SINGLETON_CHILDREN = Set.of(StoreWriteThroughResourceDefinition.PATH);
    private final UnaryOperator<ResourceDescriptor> configurator;
    private final Class<B> builderClass;

    protected static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"store", (String)value);
    }

    protected StoreResourceDefinition(PathElement path, ResourceDescriptionResolver resolver, UnaryOperator<ResourceDescriptor> configurator, Class<B> builderClass) {
        super(path, resolver);
        this.configurator = configurator;
        this.builderClass = builderClass;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttributes(Attribute.class).addAttributes(DeprecatedAttribute.class).addCapabilities(List.of(CAPABILITY)).addRequiredSingletonChildren(REQUIRED_SINGLETON_CHILDREN);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new StoreWriteBehindResourceDefinition().register(registration);
        new StoreWriteThroughResourceDefinition().register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final boolean passivation = Attribute.PASSIVATION.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean preload = Attribute.PRELOAD.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean purge = Attribute.PURGE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean segmented = Attribute.SEGMENTED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean shared = Attribute.SHARED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final int maxBatchSize = Attribute.MAX_BATCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final Properties properties = new Properties();
        for (Property property : Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model).asPropertyListOrEmpty()) {
            properties.setProperty(property.getName(), property.getValue().asString());
        }
        Object entry = this.resolve(context, model);
        final Supplier builderFactory = (Supplier)((Map.Entry)entry.getKey()).getKey();
        final Consumer configurator = (Consumer)((Map.Entry)entry.getKey()).getValue();
        Stream dependencies = (Stream)entry.getValue();
        Supplier<PersistenceConfiguration> configurationFactory = new Supplier<PersistenceConfiguration>(){

            @Override
            public PersistenceConfiguration get() {
                StoreConfigurationBuilder builder = (StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)builderFactory.get()).maxBatchSize(maxBatchSize)).preload(preload)).purgeOnStartup(purge)).segmented(segmented)).shared(shared)).withProperties(properties);
                configurator.accept(builder);
                return builder.persistence().passivation(passivation).create();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)configurationFactory).requires((Iterable)dependencies.collect(Collectors.toList()))).build();
    }

    public Map.Entry<Map.Entry<Supplier<B>, Consumer<B>>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        Supplier<StoreConfigurationBuilder> builderFactory = () -> new ConfigurationBuilder().persistence().addStore(this.builderClass);
        PathAddress address = context.getCurrentAddress();
        PathAddress cacheAddress = address.getParent();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        final ServiceDependency async = ServiceDependency.on(StoreWriteResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        Consumer configurator = new Consumer<B>(){

            @Override
            public void accept(B builder) {
                builder.async().read((AsyncStoreConfiguration)async.get(), Combine.DEFAULT);
            }
        };
        return MapEntry.of((Object)MapEntry.of(builderFactory, (Object)configurator), Stream.of(async));
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        MAX_BATCH_SIZE("max-batch-size", ModelType.INT, new ModelNode(100)),
        PASSIVATION("passivation", ModelType.BOOLEAN, ModelNode.FALSE),
        PRELOAD("preload", ModelType.BOOLEAN, ModelNode.FALSE),
        PURGE("purge", ModelType.BOOLEAN, ModelNode.FALSE),
        SHARED("shared", ModelType.BOOLEAN, ModelNode.FALSE),
        SEGMENTED("segmented", ModelType.BOOLEAN, ModelNode.TRUE),
        PROPERTIES("properties");

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(String name) {
            this.definition = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder(name).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        FETCH_STATE("fetch-state", ModelType.BOOLEAN, ModelNode.TRUE, InfinispanSubsystemModel.VERSION_16_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModelNode defaultValue, InfinispanSubsystemModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

