/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.infinispan.executors.DefaultNonBlockingThreadFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolServiceDescriptor;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public enum ThreadPoolResourceDefinition implements ResourceDefinitionProvider,
ThreadPoolDefinition,
ThreadPoolServiceDescriptor,
ResourceServiceConfigurator
{
    BLOCKING("blocking", 1, 150, 5000, TimeUnit.MINUTES.toMillis(1L), false),
    LISTENER("listener", 1, 1, 1000, TimeUnit.MINUTES.toMillis(1L), false),
    NON_BLOCKING("non-blocking", 2, 2, 1000, TimeUnit.MINUTES.toMillis(1L), true);

    static final PathElement WILDCARD_PATH;
    private final RuntimeCapability<Void> capability;
    private final PathElement path;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute queueLength;
    private final Attribute keepAliveTime;
    private final boolean nonBlocking;

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime, boolean nonBlocking) {
        this.path = ThreadPoolResourceDefinition.pathElement(name);
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.queueLength = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build());
        this.nonBlocking = nonBlocking;
        this.capability = RuntimeCapability.Builder.of((UnaryServiceDescriptor)this).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        return (SimpleAttributeDefinitionBuilder)builder.setValidator(validatorBuilder.configure((AbstractAttributeDefinitionBuilder)builder).build());
    }

    public void register(ManagementResourceRegistration parent) {
        ParentResourceDescriptionResolver resolver = InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(this.path, WILDCARD_PATH);
        SimpleResourceDefinition definition = new SimpleResourceDefinition(this.path, (ResourceDescriptionResolver)resolver);
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)definition);
        ResourceDescriptor descriptor = new ResourceDescriptor((ResourceDescriptionResolver)resolver).addAttributes(new Attribute[]{this.minThreads, this.maxThreads, this.queueLength, this.keepAliveTime});
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        int multiplier = this.nonBlocking ? ProcessorInfo.availableProcessors() : 1;
        int minThreads = this.minThreads.resolveModelAttribute((ExpressionResolver)context, model).asInt() * multiplier;
        int maxThreads = this.maxThreads.resolveModelAttribute((ExpressionResolver)context, model).asInt() * multiplier;
        int queueLength = this.queueLength.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        long keepAliveTime = this.keepAliveTime.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        Object factory = this.nonBlocking ? new NonBlockingThreadPoolExecutorFactory(maxThreads, minThreads, queueLength, keepAliveTime) : new BlockingThreadPoolExecutorFactory(maxThreads, minThreads, queueLength, keepAliveTime);
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (Object)new ThreadPoolConfigurationBuilder(null).threadPoolFactory((ThreadPoolExecutorFactory)factory).create()).asActive()).build();
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Attribute getQueueLength() {
        return this.queueLength;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }

    private static class NonBlockingThreadPoolExecutorFactory
    extends org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory {
        NonBlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
            super(maxThreads, coreThreads, queueLength, keepAlive);
        }

        public ExecutorService createExecutor(ThreadFactory factory) {
            return super.createExecutor((ThreadFactory)((Object)new DefaultNonBlockingThreadFactory(factory)));
        }
    }

    private static class BlockingThreadPoolExecutorFactory
    extends EnhancedQueueExecutorFactory {
        BlockingThreadPoolExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
            super(maxThreads, coreThreads, queueLength, keepAlive);
        }

        public ExecutorService createExecutor(ThreadFactory factory) {
            return super.createExecutor((ThreadFactory)new DefaultThreadFactory(factory, ExecutorFactory.class.getClassLoader()));
        }
    }
}

