/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.SecurityActions;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ApplyExtensionsHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "resolve-subsystems";
    private static final ModelNode APPLY_EXTENSIONS = new ModelNode();
    private final ExtensionRegistry extensionRegistry;
    private final LocalHostControllerInfo localHostInfo;
    private final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    public static final SimpleOperationDefinition DEFINITION;

    public static Operation getOperation(List<ModelNode> extensions) {
        ArrayList<ModelNode> bootOperations = new ArrayList<ModelNode>();
        for (ModelNode extension : extensions) {
            ModelNode e = new ModelNode();
            e.get("domain-resource-address").add("extension", extension.asString());
            bootOperations.add(e);
        }
        ModelNode operation = APPLY_EXTENSIONS.clone();
        operation.get("domain-model").set(bootOperations);
        return OperationBuilder.create((ModelNode)operation).build();
    }

    public ApplyExtensionsHandler(ExtensionRegistry extensionRegistry, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry) {
        this.extensionRegistry = extensionRegistry;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        ModelNode startRoot = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS));
        final ManagementResourceRegistration rootRegistration = context.getResourceRegistrationForUpdate();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        for (Resource.ResourceEntry entry : rootResource.getChildren("extension")) {
            rootResource.removeChild(entry.getPathElement());
        }
        final HashMap<String, Resource> installedExtensions = new HashMap<String, Resource>();
        HashSet<String> appliedExtensions = new HashSet<String>(this.extensionRegistry.getExtensionModuleNames());
        for (ModelNode resourceDescription : domainModel.asList()) {
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress)) continue;
            Resource resource = this.getResource(resourceAddress, rootResource, context);
            if (resourceAddress.size() != 1 || !resourceAddress.getElement(0).getKey().equals("extension")) continue;
            String module = resourceAddress.getElement(0).getValue();
            if (appliedExtensions.add(module)) {
                this.initializeExtension(module, rootRegistration);
                installedExtensions.put(module, resource);
            }
            resource.writeModel(resourceDescription.get("domain-resource-model"));
        }
        if (!context.isBooting()) {
            ModelNode finishExtensions;
            Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
            HashSet<ServerIdentity> affectedServers = new HashSet<ServerIdentity>();
            ModelNode hostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
            Map<String, ProxyController> serverProxies = DomainServerUtils.getServerProxies(this.localHostInfo.getLocalHostName(), domainRootResource, context.getResourceRegistration());
            ModelNode startExtensions = startRoot.get("extension");
            if (!startExtensions.equals(finishExtensions = endRoot.get("extension"))) {
                affectedServers.addAll(DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies));
            }
            if (!affectedServers.isEmpty()) {
                DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(affectedServers);
                Set<ServerIdentity> runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
                for (ServerIdentity serverIdentity : affectedServers) {
                    if (!runningServers.contains(serverIdentity)) continue;
                    PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)serverIdentity.getHostName()), PathElement.pathElement((String)"server", (String)serverIdentity.getServerName())});
                    OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, "server-set-reload-required");
                    ModelNode op = new ModelNode();
                    op.get("operation").set("server-set-reload-required");
                    op.get("address").set(serverAddress.toModelNode());
                    context.addStep(op, handler, OperationContext.Stage.MODEL, true);
                }
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                for (Map.Entry entry : installedExtensions.entrySet()) {
                    String module = (String)entry.getKey();
                    ApplyExtensionsHandler.this.extensionRegistry.removeExtension((Resource)entry.getValue(), module, rootRegistration);
                }
            }
        });
    }

    private Resource getResource(PathAddress resourceAddress, Resource rootResource, OperationContext context) {
        if (resourceAddress.size() == 0) {
            return rootResource;
        }
        Resource temp = rootResource;
        int idx = 0;
        for (PathElement element : resourceAddress) {
            if ((temp = temp.getChild(element)) == null) {
                String type;
                if (idx == 0 && (type = element.getKey()).equals("extension")) {
                    temp = new ExtensionResource(element.getValue(), this.extensionRegistry);
                    context.addResource(resourceAddress, temp);
                }
                if (temp != null) break;
                temp = context.createResource(resourceAddress);
                break;
            }
            ++idx;
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeExtension(String module, ManagementResourceRegistration rootRegistration) throws OperationFailedException {
        try {
            for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                if (rootRegistration.enables((Feature)extension)) {
                    ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(extension.getClass());
                    try {
                        extension.initializeParsers(this.extensionRegistry.getExtensionParsingContext(module, null));
                        extension.initialize(this.extensionRegistry.getExtensionContext(module, rootRegistration, ExtensionRegistryType.SLAVE));
                        continue;
                    }
                    finally {
                        SecurityActions.setThreadContextClassLoader(oldTccl);
                        continue;
                    }
                }
                ControllerLogger.ROOT_LOGGER.unstableExtension(extension.getClass().getName(), module);
            }
        }
        catch (ModuleLoadException e) {
            throw DomainControllerLogger.ROOT_LOGGER.failedToLoadModule(e, module);
        }
    }

    static {
        APPLY_EXTENSIONS.get("operation").set(OPERATION_NAME);
        APPLY_EXTENSIONS.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        APPLY_EXTENSIONS.get("address").setEmptyList();
        APPLY_EXTENSIONS.protect();
        DEFINITION = new SimpleOperationDefinitionBuilder(OPERATION_NAME, null).setPrivateEntry().build();
    }
}

