/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.listener;

import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.cache.infinispan.embedded.listener.NonBlockingCacheEventListener;

public class BlockingCacheEventListener<K, V>
extends NonBlockingCacheEventListener<K, V> {
    private final BlockingManager blocking;
    private final String name;

    public BlockingCacheEventListener(Cache<K, V> cache, Consumer<K> consumer) {
        this(cache, (key, value) -> consumer.accept(key), consumer.getClass());
    }

    public BlockingCacheEventListener(Cache<K, V> cache, BiConsumer<K, V> consumer) {
        this(cache, consumer, consumer.getClass());
    }

    private BlockingCacheEventListener(Cache<K, V> cache, BiConsumer<K, V> consumer, Class<?> consumerClass) {
        super(consumer);
        this.blocking = (BlockingManager)cache.getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
        this.name = consumerClass.getName();
    }

    @Override
    public CompletionStage<Void> apply(CacheEntryEvent<K, V> event) {
        return this.blocking.runBlocking(() -> super.accept(event), (Object)this.name);
    }

    @Override
    public void accept(CacheEntryEvent<K, V> event) {
        this.blocking.asExecutor(this.name).execute(() -> super.accept(event));
    }
}

