/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.wildfly.clustering.marshalling.Marshaller;

public enum IdentifierMarshaller implements Marshaller<String, ByteBuffer>
{
    ISO_LATIN_1{

        public String read(ByteBuffer buffer) throws IOException {
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException(buffer.toString());
            }
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            return new String(buffer.array(), offset, length, StandardCharsets.ISO_8859_1);
        }

        public ByteBuffer write(String value) throws IOException {
            return ByteBuffer.wrap(value.getBytes(StandardCharsets.ISO_8859_1));
        }

        @Override
        public boolean validate(String id) {
            return true;
        }
    }
    ,
    BASE64{

        public String read(ByteBuffer buffer) throws IOException {
            return (String)ISO_LATIN_1.read(Base64.getUrlEncoder().encode(buffer));
        }

        public ByteBuffer write(String value) throws IOException {
            return Base64.getUrlDecoder().decode((ByteBuffer)ISO_LATIN_1.write(value));
        }
    }
    ,
    HEX{

        public String read(ByteBuffer buffer) throws IOException {
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException(buffer.toString());
            }
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            StringBuilder builder = new StringBuilder(length * 2);
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                builder.append(Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16)));
                builder.append(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
            }
            return builder.toString();
        }

        public ByteBuffer write(String value) throws IOException {
            if (value.length() % 2 != 0) {
                throw new IllegalArgumentException(value);
            }
            byte[] bytes = new byte[value.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                int index = i * 2;
                int high = Character.digit(value.charAt(index), 16) << 4;
                int low = Character.digit(value.charAt(index + 1), 16);
                bytes[i] = (byte)(high + low);
            }
            return ByteBuffer.wrap(bytes);
        }
    };


    public boolean isMarshallable(Object object) {
        return object instanceof String;
    }

    public boolean validate(String id) {
        try {
            this.write(id);
            return true;
        }
        catch (IOException | IllegalArgumentException e) {
            return false;
        }
    }
}

