/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.jakarta.data;

import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemModel;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.version.Stability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.extension.jakarta.data._private.JakartaDataLogger;
import org.wildfly.subsystem.SubsystemConfiguration;
import org.wildfly.subsystem.SubsystemExtension;
import org.wildfly.subsystem.SubsystemPersistence;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;

public class JakartaDataExtension
extends SubsystemExtension<JakartaDataSubsystemSchema> {
    static final String SUBSYSTEM_NAME = "jakarta-data";
    private static final Stability FEATURE_STABILITY = Stability.PREVIEW;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jakarta-data");

    public JakartaDataExtension() {
        super(SubsystemConfiguration.of((String)SUBSYSTEM_NAME, (SubsystemModel)JakartaDataSubsystemModel.CURRENT, () -> new JakartaDataSubsystemRegistrar()), SubsystemPersistence.of((Enum)JakartaDataSubsystemSchema.CURRENT));
    }

    public Stability getStability() {
        return FEATURE_STABILITY;
    }

    private static void addDependencies(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, String ... moduleIdentifiers) {
        for (String moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
            JakartaDataLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        }
    }

    public static enum JakartaDataSubsystemModel implements SubsystemModel
    {
        VERSION_1_0_0(1, 0, 0);

        static final JakartaDataSubsystemModel CURRENT;
        private final ModelVersion version;

        private JakartaDataSubsystemModel(int major, int minor, int micro) {
            this.version = ModelVersion.create((int)major, (int)minor, (int)micro);
        }

        public ModelVersion getVersion() {
            return this.version;
        }

        static {
            CURRENT = VERSION_1_0_0;
        }
    }

    public static enum JakartaDataSubsystemSchema implements PersistentSubsystemSchema<JakartaDataSubsystemSchema>
    {
        VERSION_1_0_PREVIEW(1, 0, FEATURE_STABILITY);

        static final JakartaDataSubsystemSchema CURRENT;
        private final VersionedNamespace<IntVersion, JakartaDataSubsystemSchema> namespace;

        private JakartaDataSubsystemSchema(int major, int minor, Stability stability) {
            this.namespace = SubsystemSchema.createSubsystemURN((String)JakartaDataExtension.SUBSYSTEM_NAME, (Stability)stability, (IntVersion)new IntVersion(new int[]{major, minor}));
        }

        public VersionedNamespace<IntVersion, JakartaDataSubsystemSchema> getNamespace() {
            return this.namespace;
        }

        public Stability getStability() {
            return this.getNamespace().getStability();
        }

        public PersistentResourceXMLDescription getXMLDescription() {
            PersistentResourceXMLDescription.Factory factory = PersistentResourceXMLDescription.factory((PersistentSubsystemSchema)this);
            return factory.builder(SUBSYSTEM_PATH).build();
        }

        static {
            CURRENT = VERSION_1_0_PREVIEW;
        }
    }

    private static final class JakartaDataSubsystemRegistrar
    implements SubsystemResourceDefinitionRegistrar {
        private static final RuntimeCapability<Void> JAKARTA_DATA_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.jakarta.data").addRequirements(new String[]{"org.wildfly.jpa"}).build();
        static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("jakarta-data", JakartaDataSubsystemRegistrar.class);
        static final String JAKARTA_DATA_API = "jakarta.data.api";

        private JakartaDataSubsystemRegistrar() {
        }

        public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext managementResourceRegistrationContext) {
            ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)SUBSYSTEM_PATH), (ResourceDescriptionResolver)RESOLVER).build();
            ManagementResourceRegistration registration = parent.registerSubsystemModel(definition);
            ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addCapability(JAKARTA_DATA_CAPABILITY)).withDeploymentChainContributor(JakartaDataSubsystemRegistrar::registerDeploymentUnitProcessors)).build();
            ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
            registration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)JAKARTA_DATA_API)});
            return registration;
        }

        private static void registerDeploymentUnitProcessors(DeploymentProcessorTarget processorTarget) {
            processorTarget.addDeploymentProcessor(JakartaDataExtension.SUBSYSTEM_NAME, Phase.DEPENDENCIES, 4097, new DeploymentUnitProcessor(){

                public void deploy(DeploymentPhaseContext phaseContext) {
                    DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
                    ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
                    ModuleLoader moduleLoader = Module.getBootModuleLoader();
                    JakartaDataExtension.addDependencies(moduleSpecification, moduleLoader, deploymentUnit, JakartaDataSubsystemRegistrar.JAKARTA_DATA_API);
                }
            });
        }
    }
}

