/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupRemove;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.shallow.ShallowResourceDefinition;

public class DiscoveryGroupDefinition
extends ShallowResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"discovery-group");
    public static final SimpleAttributeDefinition REFRESH_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"refresh-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(10000))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition INITIAL_WAIT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-wait-timeout", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(10000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    @Deprecated
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL_FACTORY = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_CHANNEL_FACTORY).build();
    public static final SimpleAttributeDefinition JGROUPS_CHANNEL = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_CHANNEL).build();
    public static final SimpleAttributeDefinition JGROUPS_CLUSTER = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_CLUSTER).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING = SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.SOCKET_BINDING).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{JGROUPS_CHANNEL_FACTORY, JGROUPS_CHANNEL, JGROUPS_CLUSTER, SOCKET_BINDING, REFRESH_TIMEOUT, INITIAL_WAIT_TIMEOUT};

    protected DiscoveryGroupDefinition(boolean registerRuntimeOnly, boolean subsystemResource) {
        super(new SimpleResourceDefinition.Parameters(PATH, MessagingExtension.getResourceDescriptionResolver("discovery-group")).setAddHandler((OperationStepHandler)DiscoveryGroupAdd.INSTANCE).setRemoveHandler((OperationStepHandler)DiscoveryGroupRemove.INSTANCE).setDeprecationData(new DeprecationData(MessagingExtension.VERSION_9_0_0, true)).setFeature(false), registerRuntimeOnly);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    @Override
    public PathAddress convert(OperationContext context, ModelNode operation) {
        PathAddress parent = context.getCurrentAddress().getParent();
        PathAddress targetAddress = parent.append("jgroups-discovery-group", context.getCurrentAddressValue());
        try {
            context.readResourceFromRoot(targetAddress, false);
            return targetAddress;
        }
        catch (Resource.NoSuchResourceException ex) {
            return parent.append("socket-discovery-group", context.getCurrentAddressValue());
        }
    }

    @Override
    public Set<String> getIgnoredAttributes(OperationContext context, ModelNode operation) {
        PathAddress targetAddress = context.getCurrentAddress().getParent().append("jgroups-discovery-group", context.getCurrentAddressValue());
        HashSet<String> ignoredAttributes = new HashSet<String>();
        try {
            context.readResourceFromRoot(targetAddress, false);
            ignoredAttributes.add(SOCKET_BINDING.getName());
        }
        catch (Resource.NoSuchResourceException ex) {
            ignoredAttributes.add(JGROUPS_CHANNEL_FACTORY.getName());
            ignoredAttributes.add(JGROUPS_CHANNEL.getName());
            ignoredAttributes.add(JGROUPS_CLUSTER.getName());
        }
        return ignoredAttributes;
    }

    @Override
    protected boolean isUsingSocketBinding(PathAddress targetAddress) {
        return "socket-discovery-group".equals(targetAddress.getLastElement().getKey());
    }
}

