/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class HAPolicySynchronizationStatusReadHandler
extends AbstractRuntimeOnlyHandler {
    public static final AttributeDefinition SYNCHRONIZED_WITH_LIVE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized-with-live", ModelType.BOOLEAN, false).setStorageRuntime()).build();
    public static final AttributeDefinition SYNCHRONIZED_WITH_BACKUP = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized-with-backup", ModelType.BOOLEAN, false).setStorageRuntime()).build();
    public static final HAPolicySynchronizationStatusReadHandler INSTANCE = new HAPolicySynchronizationStatusReadHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        try {
            if ("read-attribute".equals(operationName)) {
                ActiveMQServerControl serverControl = this.getServerControl(context, operation);
                context.getResult().set(serverControl.isReplicaSync());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
    }

    public static void registerSlaveAttributes(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute(SYNCHRONIZED_WITH_LIVE, (OperationStepHandler)INSTANCE);
    }

    public static void registerMasterAttributes(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute(SYNCHRONIZED_WITH_BACKUP, (OperationStepHandler)INSTANCE);
    }

    private ActiveMQServerControl getServerControl(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        if (service == null || service.getState() != ServiceController.State.UP) {
            throw MessagingLogger.ROOT_LOGGER.activeMQServerNotInstalled(serviceName.getSimpleName());
        }
        ActiveMQBroker server = (ActiveMQBroker)ActiveMQBroker.class.cast(service.getValue());
        return server.getActiveMQServerControl();
    }
}

