/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.IPRange;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;

public class IPRangePredicate
implements Predicate<BaseContext> {
    @Nullable
    private Supplier<HttpServletRequest> httpRequestSupplier;
    @Nonnull
    @NonnullElements
    private Collection<IPRange> addressRanges = Collections.emptyList();

    IPRangePredicate() {
    }

    public void setRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = List.copyOf(ranges);
    }

    public void setHttpServletRequestSupplier(@Nonnull Supplier<HttpServletRequest> supplier) {
        this.httpRequestSupplier = (Supplier)Constraint.isNotNull(supplier, (String)"HttpServletRequestSupplier cannot be null");
    }

    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setHttpServletRequest", null, (String)"setHttpServletRequestSupplier");
        Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
        this.httpRequestSupplier = NonnullSupplier.of((Object)request);
    }

    public boolean test(@Nullable BaseContext input) {
        String address;
        HttpServletRequest request = this.httpRequestSupplier != null ? this.httpRequestSupplier.get() : null;
        String string = address = request != null ? HttpServletSupport.getRemoteAddr((ServletRequest)request) : null;
        if (address == null || !InetAddresses.isInetAddress((String)address)) {
            return false;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)address))) continue;
            return true;
        }
        return false;
    }
}

