/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.Version;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.RuntimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.types.ReflectionTypeFactory;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.Log;

@Deprecated
public final class ProtoSchemaBuilder {
    private static final Log log = Log.LogFactory.getLog(ProtoSchemaBuilder.class);
    public static final String DEFAULT_GENERATED_SCHEMA_NAME = "generated.proto";
    public static final String FILE_OPT = "f";
    public static final String FILE_LONG_OPT = "file";
    public static final String PACKAGE_OPT = "p";
    public static final String PACKAGE_LONG_OPT = "package";
    public static final String HELP_OPT = "h";
    public static final String HELP_LONG_OPT = "help";
    public static final String MARSHALLER_OPT = "m";
    public static final String MARSHALLER_LONG_OPT = "marshaller";
    public static final String SCHEMA_OPT = "s";
    public static final String SCHEMA_LONG_OPT = "schema";
    @Deprecated
    public static boolean generateSchemaDebugComments = false;
    private String fileName;
    private String packageName;
    private String generator;
    private final Set<Class<?>> classes = new LinkedHashSet();
    private boolean autoImportClasses = true;

    public static void main(String[] args) throws Exception {
        File file = null;
        String packageName = null;
        HashMap<String, String> schemas = new HashMap<String, String>();
        ArrayList<String> marshallers = new ArrayList<String>();
        ArrayList<String> classes = new ArrayList<String>();
        block29: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-h": 
                case "--help": {
                    System.out.printf("ProtoStream %s %s%n", Version.getVersion(), ProtoSchemaBuilder.class.getSimpleName());
                    return;
                }
                case "-f": 
                case "--file": {
                    file = new File(args[++i]);
                    continue block29;
                }
                case "-p": 
                case "--package": {
                    packageName = args[++i];
                    continue block29;
                }
                case "-s": 
                case "--schema": {
                    String[] parts = args[++i].split("=");
                    schemas.put(parts[0], parts[1]);
                    continue block29;
                }
                case "-m": 
                case "--marshaller": {
                    marshallers.add(args[++i]);
                    continue block29;
                }
                default: {
                    if (args[i].startsWith("-")) {
                        System.err.printf("Unknown option '%s'%n", args[i]);
                        return;
                    }
                    classes.add(args[i]);
                }
            }
        }
        Configuration config = Configuration.builder().build();
        SerializationContext ctx = ProtobufUtil.newSerializationContext(config);
        for (Map.Entry entry : schemas.entrySet()) {
            try (FileInputStream in = new FileInputStream((String)entry.getValue());){
                ctx.registerProtoFiles(new FileDescriptorSource().addProtoFile((String)entry.getKey(), in));
            }
        }
        for (String marshallerClass : marshallers) {
            BaseMarshaller bm = (BaseMarshaller)Class.forName(marshallerClass).newInstance();
            ctx.registerMarshaller(bm);
        }
        String fileName = file == null ? DEFAULT_GENERATED_SCHEMA_NAME : file.getName();
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder().fileName(fileName).packageName(packageName);
        for (String className : classes) {
            protoSchemaBuilder.addClass(Class.forName(className));
        }
        String schemaFile = protoSchemaBuilder.build(ctx);
        if (file != null) {
            try (PrintStream out = new PrintStream(new FileOutputStream(file));){
                out.print(schemaFile);
                out.flush();
            }
        } else {
            System.out.print(schemaFile);
        }
    }

    public ProtoSchemaBuilder fileName(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        if (!fileName.endsWith(".proto")) {
            log.warnf("File name '%s' should end with '.proto'", fileName);
        }
        this.fileName = fileName;
        return this;
    }

    public ProtoSchemaBuilder packageName(String packageName) {
        if (packageName != null && packageName.trim().isEmpty()) {
            throw new IllegalArgumentException("packageName cannot be empty");
        }
        this.packageName = packageName;
        return this;
    }

    public ProtoSchemaBuilder generator(String generator) {
        this.generator = generator;
        return this;
    }

    public ProtoSchemaBuilder addClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class argument cannot be null");
        }
        this.classes.add(clazz);
        return this;
    }

    public ProtoSchemaBuilder addClasses(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("classes argument cannot be null or empty");
        }
        Collections.addAll(this.classes, classes);
        return this;
    }

    public ProtoSchemaBuilder autoImportClasses(boolean autoImportClasses) {
        this.autoImportClasses = autoImportClasses;
        return this;
    }

    public String build(SerializationContext serializationContext) throws ProtoSchemaBuilderException, IOException {
        return this.build(serializationContext, null);
    }

    public String build(SerializationContext serializationContext, ClassLoader classLoader) throws ProtoSchemaBuilderException, IOException {
        ReflectionTypeFactory typeFactory = new ReflectionTypeFactory();
        Set xclasses = this.classes.stream().map(typeFactory::fromClass).collect(Collectors.toCollection(LinkedHashSet::new));
        BaseProtoSchemaGenerator.generateSchemaDebugComments = generateSchemaDebugComments;
        return new RuntimeProtoSchemaGenerator(typeFactory, serializationContext, this.generator, this.fileName, this.packageName, xclasses, this.autoImportClasses, classLoader).generateAndRegister();
    }
}

