/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class ThreadPoolMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final List<AttributeDefinition> metrics;
    private final ServiceName serviceNameBase;
    private final RuntimeCapability capability;

    protected ThreadPoolMetricsHandler(List<AttributeDefinition> metrics, RuntimeCapability capability, ServiceName serviceNameBase) {
        this.metrics = metrics;
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (AttributeDefinition metric : this.metrics) {
            registration.registerMetric(metric, (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String attributeName = operation.require("name").asString();
        if (context.getRunningMode() == RunningMode.NORMAL) {
            ServiceController<?> serviceController = this.getService(context, operation);
            Service service = serviceController.getService();
            this.setResult(context, attributeName, service);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected abstract void setResult(OperationContext var1, String var2, Service<?> var3) throws OperationFailedException;

    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = null;
        ServiceController controller = null;
        if (this.capability != null) {
            serviceName = this.capability.getCapabilityServiceName(context.getCurrentAddress());
            controller = context.getServiceRegistry(false).getService(serviceName);
            if (controller != null) {
                return controller;
            }
        }
        if (this.serviceNameBase != null) {
            serviceName = this.serviceNameBase.append(new String[]{name});
            controller = context.getServiceRegistry(false).getService(serviceName);
        }
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.threadPoolServiceNotFoundForMetrics(serviceName);
        }
        return controller;
    }
}

