/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.spi.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.InjectionTargetDefiningAnnotations;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadata;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.processors.WeldConfiguration;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.spi.ComponentDescriptionProcessor;
import org.jboss.as.weld.spi.WildFlyBeanDeploymentArchive;
import org.jboss.as.weld.util.Indices;
import org.jboss.as.weld.util.Utils;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.SetMultimap;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final DotName BUILD_COMPAT_EXTENSION_NAME = DotName.createSimple(BuildCompatibleExtension.class);
    private static final DotName EXTENSION_NAME = DotName.createSimple((String)Extension.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        WeldLogger.DEPLOYMENT_LOGGER.processingWeldDeployment(deploymentUnit.getName());
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        HashMap<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap = new HashMap<ResourceRoot, BeanDeploymentArchiveImpl>();
        Components components = new Components(deploymentUnit, indexes);
        ResourceRootHandler handler = new ResourceRootHandler(deploymentUnit, components, indexes);
        for (ResourceRoot resourceRoot : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
            if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot) || Utils.isClassesRoot(resourceRoot)) continue;
            handler.handleResourceRoot(bdaMap, resourceRoot);
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            handler.handleResourceRoot(bdaMap, handler.deploymentResourceRoot);
        }
        if (!bdaMap.containsKey(handler.deploymentResourceRoot)) {
            BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(Collections.emptySet(), Collections.emptySet(), BeansXml.EMPTY_BEANS_XML, handler.module, Utils.getDeploymentUnitId(deploymentUnit), BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC, true);
            WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered((BeanDeploymentArchive)bda);
            bdaMap.put(handler.deploymentResourceRoot, bda);
        }
        deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, (Object)((BeanDeploymentArchiveImpl)bdaMap.get(handler.deploymentResourceRoot)));
        for (Map.Entry entry : components.componentDescriptions.entrySet()) {
            BeanDeploymentArchiveImpl bda = (BeanDeploymentArchiveImpl)bdaMap.get(entry.getKey());
            String id = bda != null ? bda.getId() : ((BeanDeploymentArchiveImpl)deploymentUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE)).getId();
            for (ComponentDescription componentDescription : (Collection)entry.getValue()) {
                componentDescription.setBeanDeploymentArchiveId(id);
            }
        }
        BeanDeploymentModule bdm = new BeanDeploymentModule(handler.module.getIdentifier().toString(), deploymentUnit, bdaMap.values());
        deploymentUnit.putAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE, (Object)bdm);
    }

    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        context.removeAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
    }

    private static class Components {
        private final Multimap<ResourceRoot, ComponentDescription> componentDescriptions = SetMultimap.newSetMultimap();
        private final List<ComponentDescription> implicitComponentDescriptions = new ArrayList<ComponentDescription>();
        private final Iterable<ComponentDescriptionProcessor> componentDescriptionProcessors = ServiceLoader.load(ComponentDescriptionProcessor.class, WildFlySecurityManager.getClassLoaderPrivileged(BeanArchiveProcessor.class));

        public Components(DeploymentUnit deploymentUnit, Map<ResourceRoot, Index> indexes) {
            for (ComponentDescription component : ((EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION)).getComponentDescriptions()) {
                ResourceRoot resourceRoot = null;
                DotName componentClassName = DotName.createSimple((String)component.getComponentClassName());
                for (Map.Entry<ResourceRoot, Index> entry : indexes.entrySet()) {
                    Index index = entry.getValue();
                    if (index == null || index.getClassByName(componentClassName) == null) continue;
                    resourceRoot = entry.getKey();
                    break;
                }
                if (resourceRoot == null) {
                    this.implicitComponentDescriptions.add(component);
                }
                if (resourceRoot == null || Utils.isClassesRoot(resourceRoot)) {
                    resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                }
                this.componentDescriptions.put((Object)resourceRoot, (Object)component);
                for (ComponentDescriptionProcessor processor : this.componentDescriptionProcessors) {
                    processor.processComponentDescription(resourceRoot, component);
                }
            }
        }

        boolean hasBeanComponents(ResourceRoot resourceRoot) {
            for (ComponentDescriptionProcessor processor : this.componentDescriptionProcessors) {
                if (!processor.hasBeanComponents(resourceRoot)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ResourceRootHandler {
        private final DeploymentUnit deploymentUnit;
        private final Module module;
        private final Map<ResourceRoot, Index> indexes;
        private final Components components;
        private final DeploymentReflectionIndex reflectionIndex;
        private final ResourceRoot deploymentResourceRoot;
        private final ResourceRoot classesResourceRoot;
        private final ExplicitBeanArchiveMetadataContainer explicitBeanArchives;
        private final Set<AnnotationType> beanDefiningAnnotations;
        private final boolean requireBeanDescriptor;

        private ResourceRootHandler(DeploymentUnit deploymentUnit, Components components, Map<ResourceRoot, Index> indexes) {
            this.deploymentUnit = deploymentUnit;
            this.explicitBeanArchives = (ExplicitBeanArchiveMetadataContainer)deploymentUnit.getAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
            this.module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            this.indexes = indexes;
            this.components = components;
            this.reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
            this.deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            this.classesResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(WeldAttachments.CLASSES_RESOURCE_ROOT);
            HashSet<AnnotationType> annotationTypes = new HashSet<AnnotationType>((Collection)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS));
            List definingAnnotations = Utils.getRootDeploymentUnit(deploymentUnit).getAttachmentList(InjectionTargetDefiningAnnotations.INJECTION_TARGET_DEFINING_ANNOTATIONS);
            for (DotName annotation : definingAnnotations) {
                annotationTypes.add(new AnnotationType(annotation, false));
            }
            this.beanDefiningAnnotations = annotationTypes;
            this.requireBeanDescriptor = ((WeldConfiguration)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldConfiguration.ATTACHMENT_KEY)).isRequireBeanDescriptor();
        }

        private void handleResourceRoot(Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, ResourceRoot resourceRoot) {
            BeanDeploymentArchiveImpl bda = this.processResourceRoot(resourceRoot);
            if (bda != null) {
                bdaMap.put(resourceRoot, bda);
            }
        }

        private BeanDeploymentArchiveImpl processResourceRoot(ResourceRoot resourceRoot) {
            BeanDeploymentArchiveImpl bda;
            boolean isRootBda;
            ExplicitBeanArchiveMetadata metadata = null;
            if (this.explicitBeanArchives != null) {
                metadata = this.explicitBeanArchives.getBeanArchiveMetadata().get(resourceRoot);
            }
            if (metadata == null && this.requireBeanDescriptor) {
                return null;
            }
            if (metadata == null || metadata.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.ANNOTATED)) {
                Index index;
                isRootBda = resourceRoot.equals(this.deploymentResourceRoot);
                ResourceRoot indexResourceRoot = resourceRoot;
                if (resourceRoot == this.deploymentResourceRoot && this.classesResourceRoot != null) {
                    indexResourceRoot = this.classesResourceRoot;
                }
                if ((index = this.indexes.get(indexResourceRoot)) == null) {
                    return null;
                }
                if (!(metadata != null || index.getAllKnownImplementors(EXTENSION_NAME).isEmpty() && index.getAllKnownImplementors(BUILD_COMPAT_EXTENSION_NAME).isEmpty())) {
                    return null;
                }
                Set<String> beans = this.getImplicitBeanClasses(index, resourceRoot);
                Set<String> allKnownClasses = this.getAllKnownClasses(index);
                if (beans.isEmpty() && !this.components.hasBeanComponents(resourceRoot)) {
                    return null;
                }
                BeansXml beansXml = null;
                if (metadata != null) {
                    beansXml = metadata.getBeansXml();
                }
                bda = new BeanDeploymentArchiveImpl(beans, allKnownClasses, beansXml, this.module, this.createBeanArchiveId(resourceRoot), BeanDeploymentArchiveImpl.BeanArchiveType.IMPLICIT, isRootBda);
                WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered((BeanDeploymentArchive)bda);
            } else {
                if (metadata.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
                    return null;
                }
                isRootBda = metadata.isDeploymentRoot();
                bda = this.createExplicitBeanDeploymentArchive(this.indexes.get(metadata.getResourceRoot()), metadata, isRootBda);
                WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered((BeanDeploymentArchive)bda);
            }
            for (ComponentDescriptionProcessor processor : this.components.componentDescriptionProcessors) {
                processor.registerComponents(resourceRoot, (WildFlyBeanDeploymentArchive)bda, this.reflectionIndex);
            }
            return bda;
        }

        private Set<String> getAllKnownClasses(Index index) {
            HashSet<String> allKnownClasses = new HashSet<String>();
            if (index != null) {
                for (ClassInfo classInfo : index.getKnownClasses()) {
                    allKnownClasses.add(Indices.CLASS_INFO_TO_FQCN.apply(classInfo));
                }
            }
            return allKnownClasses;
        }

        private Set<String> getImplicitBeanClasses(Index index, ResourceRoot resourceRoot) {
            HashSet<String> implicitBeanClasses = new HashSet<String>();
            for (AnnotationType beanDefiningAnnotation : this.beanDefiningAnnotations) {
                List annotationInstances = index.getAnnotations(beanDefiningAnnotation.getName());
                for (ClassInfo classInfo : Indices.getAnnotatedClasses(annotationInstances)) {
                    implicitBeanClasses.add(Indices.CLASS_INFO_TO_FQCN.apply(classInfo));
                }
            }
            for (ComponentDescription description : this.components.componentDescriptions.get((Object)resourceRoot)) {
                if (this.components.implicitComponentDescriptions.contains(description)) continue;
                implicitBeanClasses.add(description.getComponentClassName());
            }
            return implicitBeanClasses;
        }

        private BeanDeploymentArchiveImpl createExplicitBeanDeploymentArchive(Index index, ExplicitBeanArchiveMetadata beanArchiveMetadata, boolean root) {
            Set<String> classNames = this.getAllKnownClasses(index);
            return new BeanDeploymentArchiveImpl(classNames, classNames, beanArchiveMetadata.getBeansXml(), this.module, this.createBeanArchiveId(beanArchiveMetadata.getResourceRoot()), BeanDeploymentArchiveImpl.BeanArchiveType.EXPLICIT, root);
        }

        private String createBeanArchiveId(ResourceRoot resourceRoot) {
            Object beanArchiveId = Utils.getDeploymentUnitId(this.deploymentUnit);
            if (resourceRoot != null) {
                VirtualFile deploymentRootResource = ((ResourceRoot)this.deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                beanArchiveId = (String)beanArchiveId + "/" + resourceRoot.getRoot().getPathNameRelativeTo(deploymentRootResource);
            }
            return beanArchiveId;
        }
    }
}

