/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.concurrent.Flow;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.IteratorSubscription;

public class IterablePublisher<T>
implements Flow.Publisher<T> {
    private final Iterable<T> iterable;

    public IterablePublisher(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        if (!this.iterable.iterator().hasNext()) {
            subscriber.onSubscribe(new AlreadyCompletedSubscription());
            subscriber.onComplete();
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(this.iterable.iterator(), subscriber));
        }
    }
}

