/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mvc.krazo;

import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.mvc.krazo.DeploymentDependenciesProcessor;
import org.wildfly.extension.mvc.krazo.MVCKrazoExtension;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;

final class MVCKrazoSubsystemRegistrar
implements SubsystemResourceDefinitionRegistrar {
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver("mvc-krazo", MVCKrazoSubsystemRegistrar.class);
    static final String MVC_API = "jakarta.mvc.api";
    static final String KRAZO_CORE = "org.eclipse.krazo.core";
    static final String KRAZO_RESTEASY = "org.eclipse.krazo.resteasy";

    MVCKrazoSubsystemRegistrar() {
    }

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext managementResourceRegistrationContext) {
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)ResourceRegistration.of((PathElement)MVCKrazoExtension.SUBSYSTEM_PATH), (ResourceDescriptionResolver)RESOLVER).build();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(definition);
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).withDeploymentChainContributor(MVCKrazoSubsystemRegistrar::registerDeploymentUnitProcessors)).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        registration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)MVC_API), RuntimePackageDependency.required((String)KRAZO_CORE), RuntimePackageDependency.required((String)KRAZO_RESTEASY)});
        return registration;
    }

    private static void registerDeploymentUnitProcessors(DeploymentProcessorTarget processorTarget) {
        processorTarget.addDeploymentProcessor("mvc-krazo", DeploymentDependenciesProcessor.PHASE, 3329, (DeploymentUnitProcessor)new DeploymentDependenciesProcessor());
    }
}

