/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldCollections {
    private WeldCollections() {
    }

    public static <T> Set<T> immutableSetView(Set<T> set) {
        if (set instanceof ImmutableSet) {
            return set;
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> List<T> immutableListView(List<T> list) {
        if (list instanceof ImmutableList) {
            return list;
        }
        if (list instanceof ArrayList) {
            ((ArrayList)ArrayList.class.cast(list)).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> immutableMapView(Map<K, V> map) {
        if (map instanceof ImmutableMap) {
            return map;
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static String toMultiRowString(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "(empty collection)";
        }
        StringBuilder builder = new StringBuilder("\n  - ");
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",\n  - ");
        }
        return builder.toString();
    }

    public static <T> boolean addIfNotNull(Collection<T> collection, T element) {
        if (element == null) {
            return false;
        }
        return collection.add(element);
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        V old = map.putIfAbsent(key, value);
        if (old != null) {
            return old;
        }
        return value;
    }
}

