/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLinkOptions;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonReceiverImpl;
import io.vertx.proton.impl.ProtonSenderImpl;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class ProtonSessionImpl
implements ProtonSession {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonSessionImpl.class);
    private final Session session;
    private int autoLinkCounter = 0;
    private Handler<AsyncResult<ProtonSession>> openHandler = result -> LOG.trace((Object)"Session open completed");
    private Handler<AsyncResult<ProtonSession>> closeHandler = result -> {
        if (result.succeeded()) {
            LOG.trace((Object)"Session closed");
        } else {
            LOG.warn((Object)"Session closed with error", result.cause());
        }
    };

    ProtonSessionImpl(Session session) {
        this.session = session;
        this.session.setContext((Object)this);
        session.setIncomingCapacity(Integer.MAX_VALUE);
    }

    @Override
    public ProtonConnection getConnection() {
        return this.getConnectionImpl();
    }

    public ProtonConnectionImpl getConnectionImpl() {
        return (ProtonConnectionImpl)this.session.getConnection().getContext();
    }

    public long getOutgoingWindow() {
        return this.session.getOutgoingWindow();
    }

    @Override
    public ProtonSession setIncomingCapacity(int bytes) {
        this.session.setIncomingCapacity(bytes);
        return this;
    }

    public int getOutgoingBytes() {
        return this.session.getOutgoingBytes();
    }

    public EndpointState getRemoteState() {
        return this.session.getRemoteState();
    }

    public int getIncomingBytes() {
        return this.session.getIncomingBytes();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.session.getRemoteCondition();
    }

    @Override
    public int getIncomingCapacity() {
        return this.session.getIncomingCapacity();
    }

    public EndpointState getLocalState() {
        return this.session.getLocalState();
    }

    @Override
    public ProtonSession setCondition(ErrorCondition condition) {
        this.session.setCondition(condition);
        return this;
    }

    @Override
    public ErrorCondition getCondition() {
        return this.session.getCondition();
    }

    public void setOutgoingWindow(long outgoingWindowSize) {
        this.session.setOutgoingWindow(outgoingWindowSize);
    }

    @Override
    public ProtonSessionImpl open() {
        this.session.open();
        this.getConnectionImpl().flush();
        return this;
    }

    @Override
    public ProtonSessionImpl close() {
        this.session.close();
        this.getConnectionImpl().flush();
        return this;
    }

    @Override
    public ProtonSessionImpl openHandler(Handler<AsyncResult<ProtonSession>> openHandler) {
        this.openHandler = openHandler;
        return this;
    }

    @Override
    public ProtonSessionImpl closeHandler(Handler<AsyncResult<ProtonSession>> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    private String generateLinkName() {
        return "auto-" + this.autoLinkCounter++;
    }

    private String getOrCreateLinkName(ProtonLinkOptions linkOptions) {
        return linkOptions.getLinkName() == null ? this.generateLinkName() : linkOptions.getLinkName();
    }

    @Override
    public ProtonReceiver createReceiver(String address) {
        return this.createReceiver(address, new ProtonLinkOptions());
    }

    @Override
    public ProtonReceiver createReceiver(String address, ProtonLinkOptions receiverOptions) {
        Receiver receiver = this.session.receiver(this.getOrCreateLinkName(receiverOptions));
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        Source source = new Source();
        source.setAddress(address);
        source.setOutcomes(outcomes);
        source.setDefaultOutcome((Outcome)Released.getInstance());
        if (receiverOptions.isDynamic()) {
            source.setDynamic(true);
        }
        Target target = new Target();
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        ProtonReceiverImpl r = new ProtonReceiverImpl(receiver);
        r.openHandler(result -> LOG.trace((Object)"Receiver open completed"));
        r.closeHandler(result -> {
            if (result.succeeded()) {
                LOG.trace((Object)"Receiver closed");
            } else {
                LOG.warn((Object)"Receiver closed with error", result.cause());
            }
        });
        r.setQoS(ProtonQoS.AT_LEAST_ONCE);
        return r;
    }

    @Override
    public ProtonSender createSender(String address) {
        return this.createSender(address, new ProtonLinkOptions());
    }

    @Override
    public ProtonSender createSender(String address, ProtonLinkOptions senderOptions) {
        Sender sender = this.session.sender(this.getOrCreateLinkName(senderOptions));
        Symbol[] outcomes = new Symbol[]{Accepted.DESCRIPTOR_SYMBOL, Rejected.DESCRIPTOR_SYMBOL, Released.DESCRIPTOR_SYMBOL, Modified.DESCRIPTOR_SYMBOL};
        Source source = new Source();
        source.setOutcomes(outcomes);
        Target target = new Target();
        target.setAddress(address);
        if (senderOptions.isDynamic()) {
            target.setDynamic(true);
        }
        sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        ProtonSenderImpl s = new ProtonSenderImpl(sender);
        if (address == null) {
            s.setAnonymousSender(true);
        }
        s.openHandler(result -> LOG.trace((Object)"Sender open completed"));
        s.closeHandler(result -> {
            if (result.succeeded()) {
                LOG.trace((Object)"Sender closed");
            } else {
                LOG.warn((Object)"Sender closed with error", result.cause());
            }
        });
        s.setQoS(ProtonQoS.AT_LEAST_ONCE);
        return s;
    }

    @Override
    public Record attachments() {
        return this.session.attachments();
    }

    @Override
    public void free() {
        this.session.free();
        this.getConnectionImpl().flush();
    }

    void fireRemoteOpen() {
        if (this.openHandler != null) {
            this.openHandler.handle(ProtonHelper.future(this, this.getRemoteCondition()));
        }
    }

    void fireRemoteClose() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(ProtonHelper.future(this, this.getRemoteCondition()));
        }
    }
}

