/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsLogging;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.JaxRsParameterProcessor;
import io.smallrye.openapi.jaxrs.JaxRsSubResourceLocator;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JaxRsAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String JAVAX_PACKAGE = "javax.ws.rs";
    private static final String JAKARTA_PACKAGE = "jakarta.ws.rs";
    private static final Predicate<DotName> isParameter = JaxRsParameter::isParameter;
    private static final Predicate<DotName> inJaxRsPackage = name -> {
        String nameString = name.toString();
        return nameString.startsWith(JAKARTA_PACKAGE) || nameString.startsWith(JAVAX_PACKAGE);
    };
    private final Deque<JaxRsSubResourceLocator> subResourceStack = new LinkedList<JaxRsSubResourceLocator>();

    public String getName() {
        return "JAX-RS";
    }

    public boolean isWrapperType(Type type) {
        return type.name().equals((Object)RestEasyConstants.REACTIVE_REST_RESPONSE) && type.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE);
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return method.parameterTypes().stream().map(Type::name).anyMatch(JaxRsConstants.ASYNC_RESPONSE::contains);
    }

    public boolean isPostMethod(MethodInfo method) {
        return this.context.annotations().hasAnnotation((AnnotationTarget)method, JaxRsConstants.POST);
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return this.context.annotations().hasAnnotation((AnnotationTarget)method, JaxRsConstants.DELETE);
    }

    public boolean isScannerInternalResponse(Type returnType) {
        return JaxRsConstants.RESPONSE.contains(returnType.name());
    }

    public boolean isMultipartOutput(Type returnType) {
        return RestEasyConstants.MULTIPART_OUTPUTS.contains(returnType.name());
    }

    public boolean isMultipartInput(Type inputType) {
        return RestEasyConstants.MULTIPART_INPUTS.contains(inputType.name());
    }

    public boolean isFrameworkContextType(Type type) {
        return JaxRsConstants.CONTEXTS.contains(type.name());
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        if (JaxRsAnnotationScanner.containsJaxrsAnnotations(instances)) {
            return true;
        }
        for (AnnotationInstance instance : instances) {
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsJaxrsAnnotations(List<AnnotationInstance> instances) {
        return instances.stream().map(AnnotationInstance::name).anyMatch(isParameter.or(inJaxRsPackage));
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.context = context;
        this.processApplicationClasses(openApi);
        this.processResourceClasses(openApi);
        return openApi;
    }

    private void processApplicationClasses(OpenAPI openApi) {
        ArrayList applications = new ArrayList();
        for (DotName applicationindicator : JaxRsConstants.APPLICATION) {
            applications.addAll(this.context.getIndex().getAllKnownSubclasses(applicationindicator));
        }
        this.processScannerExtensions(this.context, applications);
        for (ClassInfo classInfo : applications) {
            OpenAPI applicationOpenApi = this.processApplicationClass(classInfo);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processApplicationClass(ClassInfo applicationClass) {
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        AnnotationInstance applicationPathAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)applicationClass, JaxRsConstants.APPLICATION_PATH);
        if (applicationPathAnnotation == null || this.context.getConfig().applicationPathDisable()) {
            applicationPathAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)applicationClass, JaxRsConstants.PATH);
        }
        this.currentAppPath = applicationPathAnnotation != null ? applicationPathAnnotation.value().asString() : "/";
        this.processDefinitionAnnotation(this.context, applicationClass, (OpenAPI)openApi);
        this.processSecuritySchemeAnnotation(this.context, applicationClass, (OpenAPI)openApi);
        this.processServerAnnotation(this.context, applicationClass, (OpenAPI)openApi);
        return openApi;
    }

    private void processResourceClasses(OpenAPI openApi) {
        ArrayList<ClassInfo> resourceClasses = new ArrayList<ClassInfo>();
        resourceClasses.addAll(this.getJaxRsResourceClasses());
        resourceClasses.addAll(this.getConfigurationResourceClasses());
        for (ClassInfo resourceClass : resourceClasses) {
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)resourceClass, null);
            this.context.getResolverStack().push(resolver);
            Set tags = this.processTags(this.context, (AnnotationTarget)resourceClass, openApi, false);
            this.processResourceClass(openApi, resourceClass, null, tags);
            this.context.getResolverStack().pop();
        }
    }

    private void processResourceClass(OpenAPI openApi, ClassInfo resourceClass, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        JaxRsLogging.log.processingClass(resourceClass.simpleName());
        this.processSecuritySchemeAnnotation(this.context, resourceClass, openApi);
        this.processJavaSecurity(this.context, resourceClass, openApi);
        this.processResourceMethods(resourceClass, openApi, locatorPathParameters, tagRefs);
    }

    private void processResourceMethods(ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        Map<DotName, List<AnnotationInstance>> exceptionAnnotationMap = this.processExceptionMappers();
        List methods = this.getResourceMethods(this.context, resourceClass);
        Collections.reverse(methods);
        for (MethodInfo methodInfo : methods) {
            AtomicInteger resourceCount = new AtomicInteger(0);
            JaxRsConstants.HTTP_METHODS.stream().filter(arg_0 -> ((MethodInfo)methodInfo).hasAnnotation(arg_0)).map(DotName::withoutPackagePrefix).map(PathItem.HttpMethod::valueOf).distinct().forEach(httpMethod -> {
                resourceCount.incrementAndGet();
                this.processResourceMethod(resourceClass, methodInfo, (PathItem.HttpMethod)httpMethod, tagRefs, locatorPathParameters, exceptionAnnotationMap);
            });
            if (resourceCount.get() != 0 || !this.context.annotations().hasAnnotation((AnnotationTarget)methodInfo, JaxRsConstants.PATH)) continue;
            this.processSubResource(resourceClass, methodInfo, openApi, locatorPathParameters, tagRefs);
        }
    }

    private Map<DotName, List<AnnotationInstance>> processExceptionMappers() {
        ArrayList exceptionMappers = new ArrayList();
        for (DotName dn : JaxRsConstants.EXCEPTION_MAPPER) {
            exceptionMappers.addAll(this.context.getIndex().getKnownDirectImplementors(dn));
        }
        return exceptionMappers.stream().flatMap(this::exceptionResponseAnnotations).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<Map.Entry<DotName, List<AnnotationInstance>>> exceptionResponseAnnotations(ClassInfo classInfo) {
        Type exceptionType = classInfo.interfaceTypes().stream().filter(it -> JaxRsConstants.EXCEPTION_MAPPER.contains(it.name())).filter(it -> Type.Kind.PARAMETERIZED_TYPE.equals((Object)it.kind())).map(Type::asParameterizedType).map(type -> (Type)type.arguments().get(0)).findAny().orElse(null);
        if (exceptionType == null) {
            return Stream.empty();
        }
        Stream methodAnnotations = Stream.of(classInfo.method("toResponse", new Type[]{exceptionType})).filter(Objects::nonNull).flatMap(m -> ResponseReader.getResponseAnnotations((AnnotationScannerContext)this.context, (AnnotationTarget)m).stream());
        Stream classAnnotations = ResponseReader.getResponseAnnotations((AnnotationScannerContext)this.context, (AnnotationTarget)classInfo).stream();
        List annotations = Stream.concat(classAnnotations, methodAnnotations).filter(ResponseReader::hasResponseCodeValue).collect(Collectors.toList());
        if (annotations.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(JaxRsAnnotationScanner.entryOf(exceptionType.name(), annotations));
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private void processSubResource(ClassInfo resourceClass, MethodInfo method, OpenAPI openApi, List<Parameter> locatorPathParameters, Set<String> tagRefs) {
        Type methodReturnType = this.context.getResourceTypeResolver().resolve(method.returnType());
        if (Type.Kind.VOID.equals((Object)methodReturnType.kind())) {
            return;
        }
        JaxRsSubResourceLocator locator = new JaxRsSubResourceLocator(resourceClass, method);
        ClassInfo subResourceClass = this.context.getIndex().getClassByName(methodReturnType.name());
        if (subResourceClass != null && !this.subResourceStack.contains(locator)) {
            Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)this.context, (AnnotationInstance)t);
            ResourceParameters params = JaxRsParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
            String originalAppPath = this.currentAppPath;
            String subResourcePath = this.subResourceStack.isEmpty() ? params.getFullOperationPath() : params.getOperationPath();
            this.currentAppPath = JaxRsAnnotationScanner.createPathFromSegments((String[])new String[]{this.currentAppPath, subResourcePath});
            this.subResourceStack.push(locator);
            TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)subResourceClass, (Type)methodReturnType);
            this.context.getResolverStack().push(resolver);
            Set subresourceTags = Optional.ofNullable(this.processTags(this.context, (AnnotationTarget)method, openApi, true)).orElseGet(() -> Optional.ofNullable(this.processTags(this.context, (AnnotationTarget)subResourceClass, openApi, true)).orElse(tagRefs));
            this.processResourceClass(openApi, subResourceClass, ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters(), params.getOperationParameters()}), subresourceTags);
            this.context.getResolverStack().pop();
            this.subResourceStack.pop();
            this.currentAppPath = originalAppPath;
        }
    }

    private void processResourceMethod(ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, Set<String> resourceTags, List<Parameter> locatorPathParameters, Map<DotName, List<AnnotationInstance>> exceptionAnnotationMap) {
        JaxRsLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = this.getDefaultConsumes(this.context, method, this.getResourceParameters(resourceClass, method));
        this.context.setDefaultConsumes(defaultConsumes);
        this.context.setCurrentConsumes((String[])this.getMediaTypes(method, JaxRsConstants.CONSUMES, defaultConsumes).orElse(null));
        String[] defaultProduces = this.getDefaultProduces(this.context, method);
        this.context.setDefaultProduces(defaultProduces);
        this.context.setCurrentProduces((String[])this.getMediaTypes(method, JaxRsConstants.PRODUCES, defaultProduces).orElse(null));
        Optional maybeOperation = this.processOperation(this.context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(this.context, method, this.context.getOpenApi(), resourceTags, operation);
        ResourceParameters params = this.getResourceParameters(resourceClass, method);
        List operationParams = params.getOperationParameters();
        operation.setParameters(operationParams);
        if (locatorPathParameters != null && operationParams != null) {
            locatorPathParameters = JaxRsAnnotationScanner.excludeOperationParameters(locatorPathParameters, operationParams);
        }
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(this.context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(this.context, resourceClass, method, operation, exceptionAnnotationMap);
        this.processSecurityRequirementAnnotation(this.context, resourceClass, method, operation);
        this.processCallback(this.context, method, operation);
        this.processServerAnnotation(this.context, method, operation);
        this.processExtensions(this.context, method, operation);
        this.context.getJavaSecurityProcessor().processSecurityRoles(method, operation);
        this.setOperationOnPathItem(methodType, (PathItem)pathItem, operation);
        if (!JaxRsAnnotationScanner.processProfiles((OpenApiConfig)this.context.getConfig(), (Extensible)operation)) {
            return;
        }
        String path = this.subResourceStack.isEmpty() ? super.makePath(params.getFullOperationPath()) : super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)this.context.getOpenApi()).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)this.context.getOpenApi()).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    private ResourceParameters getResourceParameters(ClassInfo resourceClass, MethodInfo method) {
        Function<AnnotationInstance, Parameter> reader = t -> ParameterReader.readParameter((AnnotationScannerContext)this.context, (AnnotationInstance)t);
        return JaxRsParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
    }

    static List<Parameter> excludeOperationParameters(List<Parameter> locatorParams, List<Parameter> operationParams) {
        return locatorParams.stream().filter(param -> operationParams.stream().noneMatch(oParam -> Objects.equals(param.getName(), oParam.getName()) && Objects.equals(param.getIn(), oParam.getIn()))).collect(Collectors.toList());
    }

    Optional<String[]> getMediaTypes(MethodInfo resourceMethod, Set<DotName> annotationName, String[] defaultValue) {
        return this.context.getAugmentedIndex().ancestry(resourceMethod).entrySet().stream().map(e -> this.getMediaTypeAnnotation((ClassInfo)e.getKey(), (MethodInfo)e.getValue(), annotationName)).filter(Objects::nonNull).map(annotation -> JaxRsAnnotationScanner.mediaTypeValue(annotation, defaultValue)).findFirst();
    }

    AnnotationInstance getMediaTypeAnnotation(ClassInfo clazz, MethodInfo method, Set<DotName> annotationName) {
        AnnotationInstance annotation = null;
        if (method != null) {
            annotation = this.context.annotations().getAnnotation((AnnotationTarget)method, annotationName);
        }
        if (annotation == null) {
            annotation = this.context.annotations().getAnnotation((AnnotationTarget)clazz, annotationName);
        }
        return annotation;
    }

    static String[] mediaTypeValue(AnnotationInstance mediaTypeAnnotation, String[] defaultValue) {
        AnnotationValue annotationValue = mediaTypeAnnotation.value();
        if (annotationValue != null) {
            return JaxRsAnnotationScanner.flattenAndTrimMediaTypes(annotationValue.asStringArray());
        }
        return defaultValue;
    }

    static String[] flattenAndTrimMediaTypes(String[] mediaTypes) {
        return (String[])Arrays.stream(mediaTypes).map(mediaType -> mediaType.split(",")).flatMap(Arrays::stream).map(String::trim).toArray(String[]::new);
    }

    private Collection<ClassInfo> getJaxRsResourceClasses() {
        ArrayList pathAnnotations = new ArrayList();
        for (DotName dn : JaxRsConstants.PATH) {
            pathAnnotations.addAll(this.context.getIndex().getAnnotations(dn));
        }
        return pathAnnotations.stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(this::hasImplementationOrIsIncluded).collect(Collectors.toCollection(() -> new TreeSet((one, two) -> one.name().compareTo(two.name()))));
    }

    private Collection<ClassInfo> getConfigurationResourceClasses() {
        return this.context.getConfig().getScanResourceClasses().keySet().stream().map(DotName::createSimple).map(className -> this.context.getIndex().getClassByName(className)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean hasImplementationOrIsIncluded(ClassInfo clazz) {
        if (this.neitherIterfaceNorSyntheticRestClient(clazz)) {
            return true;
        }
        FilteredIndexView filteredIndex = this.context.getIndex();
        if (filteredIndex.getAllKnownImplementors(clazz.name()).stream().anyMatch(this::neitherAbstractNorSynthetic)) {
            return true;
        }
        return filteredIndex.explicitlyAccepts(clazz.name());
    }

    private boolean neitherIterfaceNorSyntheticRestClient(ClassInfo clazz) {
        if (Modifier.isInterface(clazz.flags())) {
            return false;
        }
        if (!clazz.isSynthetic()) {
            return true;
        }
        AugmentedIndexView index = this.context.getAugmentedIndex();
        return index.inheritanceChain(clazz, Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS)).entrySet().stream().flatMap(e -> index.interfaces((ClassInfo)e.getKey()).stream()).map(arg_0 -> ((AugmentedIndexView)index).getClass(arg_0)).filter(Objects::nonNull).noneMatch(iface -> this.context.annotations().getAnnotation((AnnotationTarget)iface, new DotName[]{JaxRsConstants.REGISTER_REST_CLIENT}) != null);
    }

    private boolean neitherAbstractNorSynthetic(ClassInfo clazz) {
        return !Modifier.isAbstract(clazz.flags()) && !clazz.isSynthetic();
    }
}

