/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.ActionSourceAttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.io.Serializable;

public class SetPropertyActionListenerHandler
extends TagHandlerImpl
implements ActionSourceAttachedObjectHandler {
    private final TagAttribute value = this.getRequiredAttribute("value");
    private final TagAttribute target = this.getRequiredAttribute("target");

    public SetPropertyActionListenerHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || !ComponentHandler.isNew(parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent(parent)) {
            if (this.getFor() == null) {
                throw new TagException(this.tag, "actionListener tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add(this);
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        ActionSource src = (ActionSource)((Object)parent);
        ValueExpression valueExpr = this.value.getValueExpression(faceletContext, Object.class);
        ValueExpression targetExpr = this.target.getValueExpression(faceletContext, Object.class);
        src.addActionListener(new SetPropertyListener(valueExpr, targetExpr));
    }

    @Override
    public String getFor() {
        String result = null;
        TagAttribute attr = this.getAttribute("for");
        if (attr != null) {
            if (attr.isLiteral()) {
                result = attr.getValue();
            } else {
                FaceletContext ctx = (FaceletContext)((Object)FacesContext.getCurrentInstance().getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
                result = (String)attr.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            }
        }
        return result;
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -2760242070551459725L;
        private ValueExpression value;
        private ValueExpression target;

        public SetPropertyListener(ValueExpression value, ValueExpression target) {
            this.value = value;
            this.target = target;
        }

        @Override
        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object valueObj = this.value.getValue(elContext);
            if (valueObj != null) {
                valueObj = facesContext.getApplication().getExpressionFactory().coerceToType(valueObj, this.target.getType(elContext));
            }
            this.target.setValue(elContext, valueObj);
        }
    }
}

