/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.util;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;

public class ReflectionUtil {
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, false, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static <T> T newInstance(String name) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ReflectionUtil.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Class[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ReflectionUtil.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    protected static String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type : types) {
                sb.append(type.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    public static Object decorateInstance(Class clazz, Class rootType, Object root) {
        Object returnObject = null;
        try {
            Constructor<?> construct;
            if (returnObject == null && rootType != null && root != null && (construct = ReflectionUtils.lookupConstructor(clazz, rootType)) != null) {
                returnObject = construct.newInstance(root);
            }
            if (clazz != null && returnObject == null) {
                returnObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", clazz.getName(), e.toString())), e);
        }
        return returnObject;
    }

    public static Object decorateInstance(String className, Class rootType, Object root) {
        Object returnObject = null;
        if (className != null) {
            try {
                Class<?> clazz = ReflectionUtil.loadClass(className, returnObject, null);
                if (clazz != null) {
                    returnObject = ReflectionUtil.decorateInstance(clazz, rootType, root);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to find class ''{0}''", className)));
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Class ''{0}'' is missing a runtime dependency: {1}", className, ncdfe.toString())));
            }
            catch (ClassCastException cce) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Class ''{0}'' is not an instance of ''{1}''", className, rootType)));
            }
            catch (Exception e) {
                throw new ConfigurationException(ReflectionUtil.buildMessage(MessageFormat.format("Unable to create a new instance of ''{0}'': {1}", className, e.toString())), e);
            }
        }
        return returnObject;
    }

    private static String buildMessage(String cause) {
        return MessageFormat.format("\n  Source Document: {0}\n  Cause: {1}", "web.xml", cause);
    }

    private static Class<?> loadClass(String className, Object fallback, Class<?> expectedType) throws ClassNotFoundException {
        Class clazz = Util.loadClass(className, fallback);
        if (expectedType != null && !expectedType.isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        return clazz;
    }
}

