/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.ejb.bean.BeanDeploymentMarshallingContext;
import org.wildfly.clustering.ejb.bean.BeanManagementConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.ejb.cache.bean.BeanMarshallerFactory;
import org.wildfly.clustering.ejb.remote.ClientMappingsRegistryProvider;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.extension.clustering.ejb.DistributableEjbExtension;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public abstract class BeanManagementResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<BeanManagementConfiguration> {
    static final RuntimeCapability<Void> BEAN_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((UnaryServiceDescriptor)BeanManagementProvider.SERVICE_DESCRIPTOR).addRequirements(new String[]{ClientMappingsRegistryProvider.SERVICE_DESCRIPTOR.getName()}).setAllowMultipleRegistrations(true).build();
    private final UnaryOperator<ResourceDescriptor> configurator;

    BeanManagementResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, (ResourceDescriptionResolver)DistributableEjbExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, PathElement.pathElement((String)"bean-management")));
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(BEAN_MANAGEMENT_PROVIDER));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar((ResourceDescriptor)this.configurator.apply(descriptor), ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        return registration;
    }

    public BeanManagementConfiguration resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final OptionalInt maxActiveBeans = Optional.ofNullable(Attribute.MAX_ACTIVE_BEANS.getDefinition().resolveModelAttribute(context, model).asIntOrNull()).map(OptionalInt::of).orElse(OptionalInt.empty());
        return new BeanManagementConfiguration(){

            public OptionalInt getMaxActiveBeans() {
                return maxActiveBeans;
            }

            public Function<BeanDeploymentMarshallingContext, ByteBufferMarshaller> getMarshallerFactory() {
                return BeanMarshallerFactory.JBOSS;
            }
        };
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        MAX_ACTIVE_BEANS("max-active-beans", ModelType.INT){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setValidator(new IntRangeValidatorBuilder().min(1).configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

