/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedAnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedClassUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedFieldReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotatedMethodReference;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ClassInformation;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ExtendsAnnotatedClass;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ImplementsAnnotatedInterface;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.JandexIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ReusableStreams;

class ClassInfoCollector {
    private final RuntimeIndex runtimeIndex;
    private final ReusableStreams reusableStreams = new ReusableStreams();
    private final Set<AnnotationUsage> usages = new LinkedHashSet<AnnotationUsage>();

    ClassInfoCollector(RuntimeIndex runtimeIndex) {
        this.runtimeIndex = runtimeIndex;
    }

    Set<AnnotationUsage> getUsages() {
        return this.usages;
    }

    void processClass(ClassInformation classInfo) throws IOException {
        Set<String> annotations;
        ClassReferences classReferences = new ClassReferences();
        int[] tags = classInfo.getTags();
        block5: for (int i = 0; i < tags.length; ++i) {
            int pos = i + 1;
            int tag = tags[i];
            switch (tag) {
                case 9: {
                    Set<String> annotations2 = this.runtimeIndex.getAnnotationsForField(classInfo.getClassNameFromRefInfo(pos), () -> classInfo.getNameFromRefInfo(pos));
                    if (annotations2 == null) continue block5;
                    this.recordFieldUsage(classInfo, annotations2, classInfo.getClassNameFromRefInfo(pos), classInfo.getNameFromRefInfo(pos));
                    continue block5;
                }
                case 10: 
                case 11: {
                    Set<String> annotations2 = this.runtimeIndex.getAnnotationsForMethod(classInfo.getClassNameFromRefInfo(pos), () -> classInfo.getNameFromRefInfo(pos), () -> classInfo.getDescriptorFromRefInfo(pos));
                    if (annotations2 == null) continue block5;
                    this.recordMethodUsage(classInfo, annotations2, classInfo.getClassNameFromRefInfo(pos), classInfo.getNameFromRefInfo(pos), classInfo.getDescriptorFromRefInfo(pos));
                    continue block5;
                }
                case 7: {
                    RuntimeIndex.ByteArrayKey key = classInfo.getClassNameFromClassInfo(pos);
                    Set<String> annotations3 = this.runtimeIndex.getAnnotationsForClass(key);
                    if (annotations3 == null) continue block5;
                    classReferences.classes.put(this.runtimeIndex.getClassNameFromKey(key), annotations3);
                }
            }
        }
        RuntimeIndex.ByteArrayKey superClass = classInfo.getSuperClass();
        if (superClass != null && !RuntimeIndex.JAVA_LANG_OBJECT_KEY.equals(superClass) && (annotations = this.runtimeIndex.getAnnotationsForClass(superClass)) != null) {
            String superClassName = RuntimeIndex.convertClassNameToDotFormat(superClass.convertBytesToString(this.reusableStreams));
            this.recordSuperClassUsage(classInfo, annotations, superClassName);
            classReferences.indirectReferences.add(superClassName);
        }
        for (RuntimeIndex.ByteArrayKey iface : classInfo.getInterfaces()) {
            Set<String> annotations4 = this.runtimeIndex.getAnnotationsForClass(iface);
            if (annotations4 == null) continue;
            String ifaceName = RuntimeIndex.convertClassNameToDotFormat(iface.convertBytesToString(this.reusableStreams));
            this.recordImplementsInterfaceUsage(classInfo, annotations4, ifaceName);
            classReferences.indirectReferences.add(ifaceName);
        }
        classReferences.recordClassUsage(classInfo.getScannedClassName(this.reusableStreams));
    }

    boolean checkAnnotationIndex(JandexIndex annotationIndex) {
        return new AnnotationIndexChecker(annotationIndex).checkAnnotationIndex();
    }

    private void recordMethodUsage(ClassInformation classInfo, Set<String> annotations, RuntimeIndex.ByteArrayKey classNameFromReference, RuntimeIndex.ByteArrayKey nameFromReference, RuntimeIndex.ByteArrayKey descriptorFromReference) throws IOException {
        String scannedClass = classInfo.getScannedClassName(this.reusableStreams);
        AnnotatedMethodReference annotatedMethodReference = new AnnotatedMethodReference(annotations, scannedClass, this.runtimeIndex.getClassNameFromKey(classNameFromReference), this.runtimeIndex.getMethodNameFromKey(nameFromReference), this.runtimeIndex.getMethodDescriptorsFromKey(descriptorFromReference));
        this.usages.add(annotatedMethodReference);
    }

    private void recordFieldUsage(ClassInformation classInfo, Set<String> annotations, RuntimeIndex.ByteArrayKey classNameFromReference, RuntimeIndex.ByteArrayKey nameFromReference) throws IOException {
        String scannedClass = classInfo.getScannedClassName(this.reusableStreams);
        AnnotatedFieldReference annotatedFieldReference = new AnnotatedFieldReference(annotations, scannedClass, this.runtimeIndex.getClassNameFromKey(classNameFromReference), this.runtimeIndex.getFieldNameFromKey(nameFromReference));
        this.usages.add(annotatedFieldReference);
    }

    private void recordImplementsInterfaceUsage(ClassInformation classInfo, Set<String> annotations, String ifaceName) throws IOException {
        String scannedClass = classInfo.getScannedClassName(this.reusableStreams);
        this.usages.add(new ImplementsAnnotatedInterface(annotations, scannedClass, ifaceName));
    }

    private void recordSuperClassUsage(ClassInformation classInfo, Set<String> annotations, String superClassName) throws IOException {
        String scannedClass = classInfo.getScannedClassName(this.reusableStreams);
        this.usages.add(new ExtendsAnnotatedClass(annotations, scannedClass, superClassName));
    }

    private class AnnotationIndexChecker {
        private final JandexIndex annotationIndex;
        private final Map<String, Set<String>> classAnnotations = new HashMap<String, Set<String>>();

        public AnnotationIndexChecker(JandexIndex annotationIndex) {
            this.annotationIndex = annotationIndex;
        }

        public boolean checkAnnotationIndex() {
            HashMap annotationsByTarget = new HashMap();
            for (String string : ClassInfoCollector.this.runtimeIndex.getAnnotatedAnnotations()) {
                Collection<AnnotationInstance> annotationInstances = this.annotationIndex.getAnnotations(string);
                for (AnnotationInstance instance : annotationInstances) {
                    AnnotationTarget target = instance.target();
                    if (target.kind() == AnnotationTarget.Kind.TYPE) {
                        target = target.asType().enclosingTarget();
                    }
                    if (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                        this.addClassAnnotation(target.asMethodParameter().method().declaringClass().name().toString(), string);
                        continue;
                    }
                    if (target.kind() == AnnotationTarget.Kind.METHOD) {
                        this.addClassAnnotation(target.asMethod().declaringClass().name().toString(), string);
                        continue;
                    }
                    if (target.kind() == AnnotationTarget.Kind.CLASS) {
                        this.addClassAnnotation(target.asClass().name().toString(), string);
                        continue;
                    }
                    if (target.kind() == AnnotationTarget.Kind.FIELD) {
                        this.addClassAnnotation(target.asField().declaringClass().name().toString(), string);
                        continue;
                    }
                    if (target.kind() != AnnotationTarget.Kind.RECORD_COMPONENT) continue;
                    this.addClassAnnotation(target.asRecordComponent().declaringClass().name().toString(), string);
                }
            }
            if (this.classAnnotations.isEmpty()) {
                return true;
            }
            for (Map.Entry entry : this.classAnnotations.entrySet()) {
                ClassInfoCollector.this.usages.add(new AnnotatedAnnotationUsage((String)entry.getKey(), (Set)entry.getValue()));
            }
            return false;
        }

        private void addClassAnnotation(String clazz, String annotation) {
            Set annotations = this.classAnnotations.computeIfAbsent(clazz, s -> new HashSet());
            annotations.add(annotation);
        }
    }

    private class ClassReferences {
        private final Set<String> indirectReferences = new HashSet<String>();
        private final Map<String, Set<String>> classes = new HashMap<String, Set<String>>();

        private ClassReferences() {
        }

        boolean recordClassUsage(String className) {
            boolean empty = true;
            for (String s : this.indirectReferences) {
                this.classes.remove(s);
            }
            for (String referencedClass : this.classes.keySet()) {
                ClassInfoCollector.this.usages.add(new AnnotatedClassUsage(this.classes.get(referencedClass), className, referencedClass));
                empty = false;
            }
            return empty;
        }
    }
}

