/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagementSupport;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverInfo;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeFromAddressReceiver
extends AMQPBridgeReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AMQPBridgeFromAddressReceiver(AMQPBridgeFromPolicyManager policyManager, AMQPBridgeReceiverConfiguration configuration, AMQPSessionContext session, AMQPBridgeReceiverInfo receiverInfo, AMQPBridgeAddressPolicy policy, AMQPBridgeMetrics.ReceiverMetrics metrics) {
        super(policyManager, configuration, session, receiverInfo, policy, metrics);
    }

    @Override
    public int getReceiverIdleTimeout() {
        return this.configuration.getAddressReceiverIdleTimeout();
    }

    @Override
    protected void doCreateReceiver() {
        try {
            HashMap<Symbol, Integer> receiverProperties;
            Receiver protonReceiver = this.session.getSession().receiver(this.generateLinkName());
            Target target = new Target();
            Source source = new Source();
            String address = this.receiverInfo.getRemoteAddress();
            String filterString = this.receiverInfo.getFilterString();
            source.setOutcomes(Arrays.copyOf(OUTCOMES, OUTCOMES.length));
            source.setDefaultOutcome((Outcome)DEFAULT_OUTCOME);
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            source.setAddress(address);
            source.setCapabilities(this.getRemoteTerminusCapabilities());
            if (filterString != null && !filterString.isBlank()) {
                AmqpJmsSelectorFilter jmsFilter = new AmqpJmsSelectorFilter(filterString);
                HashMap<Symbol, AmqpJmsSelectorFilter> filtersMap = new HashMap<Symbol, AmqpJmsSelectorFilter>();
                filtersMap.put(AmqpSupport.JMS_SELECTOR_KEY, jmsFilter);
                source.setFilter(filtersMap);
            }
            target.setAddress(this.receiverInfo.getLocalAddress());
            if (this.receiverInfo.getPriority() != null) {
                receiverProperties = new HashMap<Symbol, Integer>();
                receiverProperties.put(AmqpSupport.RECEIVER_PRIORITY, this.receiverInfo.getPriority());
            } else {
                receiverProperties = null;
            }
            protonReceiver.setSenderSettleMode(this.configuration.isUsingPresettledSenders() ? SenderSettleMode.SETTLED : SenderSettleMode.UNSETTLED);
            protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (this.configuration.isCoreMessageTunnelingEnabled()) {
                protonReceiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
            }
            protonReceiver.setProperties(receiverProperties);
            protonReceiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            protonReceiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            protonReceiver.open();
            AtomicBoolean openTimedOut = new AtomicBoolean(false);
            ScheduledFuture<?> openTimeoutTask = this.configuration.getLinkAttachTimeout() > 0 ? this.bridgeManager.getServer().getScheduledPool().schedule(() -> {
                openTimedOut.set(true);
                this.bridgeManager.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
            }, (long)this.configuration.getLinkAttachTimeout(), TimeUnit.SECONDS) : null;
            this.protonReceiver = protonReceiver;
            protonReceiver.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                try {
                    if (openTimeoutTask != null) {
                        openTimeoutTask.cancel(false);
                    }
                    if (openTimedOut.get()) {
                        return;
                    }
                    boolean linkOpened = protonReceiver.getRemoteSource() != null;
                    this.bridgeManager.addLinkClosedInterceptor(this.receiverInfo.getId(), this::remoteLinkClosedInterceptor);
                    this.receiver = new AMQPBridgeAddressDeliveryReceiver(this.session, this.receiverInfo, protonReceiver);
                    if (linkOpened) {
                        logger.debug("AMQP Bridge {} address receiver {} completed open", (Object)this.bridgeManager.getName(), (Object)this.receiverInfo);
                    } else {
                        logger.debug("AMQP Bridge {} address receiver {} rejected by remote", (Object)this.bridgeManager.getName(), (Object)this.receiverInfo);
                    }
                    this.session.addReceiver(protonReceiver, (session, protonRcvr) -> this.receiver);
                    if (linkOpened && this.remoteOpenHandler != null) {
                        this.remoteOpenHandler.accept(this);
                    }
                }
                catch (Exception e) {
                    this.bridgeManager.signalError(e);
                }
            });
        }
        catch (Exception e) {
            this.bridgeManager.signalError(e);
        }
        this.connection.flush();
    }

    private String generateLinkName() {
        return "amqp-bridge-" + this.bridgeManager.getName() + "-policy-" + this.policy.getPolicyName() + "-address-receiver-" + this.receiverInfo.getRemoteAddress() + "-" + String.valueOf(this.bridgeManager.getServer().getNodeID()) + "-" + LINK_SEQUENCE_ID.incrementAndGet();
    }

    private class AMQPBridgeAddressDeliveryReceiver
    extends ProtonServerReceiverContext {
        private final SimpleString cachedAddress;
        private boolean closed;

        AMQPBridgeAddressDeliveryReceiver(AMQPSessionContext session, AMQPBridgeReceiverInfo receiverInfo, Receiver receiver) {
            super(session.getSessionSPI(), session.getAMQPConnectionContext(), session, receiver);
            this.cachedAddress = SimpleString.of((String)receiverInfo.getLocalAddress());
        }

        @Override
        public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
            super.close(remoteLinkClose);
            if (!this.closed) {
                this.closed = true;
                try {
                    AMQPBridgeManagementSupport.unregisterBridgeReceiver(AMQPBridgeFromAddressReceiver.this);
                }
                catch (Exception e) {
                    logger.debug("Error caught when trying to remove bridge address consumer from management", (Throwable)e);
                }
                if (remoteLinkClose && AMQPBridgeFromAddressReceiver.this.remoteCloseHandler != null) {
                    try {
                        AMQPBridgeFromAddressReceiver.this.remoteCloseHandler.accept(AMQPBridgeFromAddressReceiver.this);
                    }
                    catch (Exception e) {
                        logger.debug("User remote closed handler threw error: ", (Throwable)e);
                    }
                    finally {
                        AMQPBridgeFromAddressReceiver.this.remoteCloseHandler = null;
                    }
                }
            }
        }

        @Override
        protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
            return AMQPBridgeAddressDeliveryReceiver.createCreditRunnable(AMQPBridgeFromAddressReceiver.this.configuration.getReceiverCredits(), AMQPBridgeFromAddressReceiver.this.configuration.getReceiverCreditsLow(), this.receiver, connection, this);
        }

        @Override
        protected int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
            return AMQPBridgeFromAddressReceiver.this.configuration.getLargeMessageThreshold();
        }

        @Override
        public void initialize() throws Exception {
            this.initialized = true;
            Target target = (Target)this.receiver.getRemoteTarget();
            this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
            this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (target == null || target.getAddress() == null || target.getAddress().isEmpty()) {
                throw new ActiveMQAMQPInternalErrorException("Remote should have sent a valid Target but we got: " + String.valueOf(target));
            }
            if (!target.getAddress().equals(AMQPBridgeFromAddressReceiver.this.receiverInfo.getLocalAddress())) {
                throw new ActiveMQAMQPInternalErrorException("Remote should have sent a matching Target address but we got: " + target.getAddress());
            }
            this.address = SimpleString.of((String)AMQPBridgeFromAddressReceiver.this.receiverInfo.getLocalAddress());
            this.defRoutingType = AMQPBridgeFromAddressReceiver.this.receiverInfo.getRoutingType();
            try {
                AddressQueryResult result = this.sessionSPI.addressQuery(this.address, this.defRoutingType, false);
                if (!result.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            if (AMQPBridgeFromAddressReceiver.this.configuration.isCoreMessageTunnelingEnabled() && AmqpSupport.verifyDesiredCapability((Link)AMQPBridgeFromAddressReceiver.this.protonReceiver, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT)) {
                this.enableCoreTunneling();
            }
            try {
                AMQPBridgeManagementSupport.registerBridgeReceiver(AMQPBridgeFromAddressReceiver.this);
            }
            catch (Exception e) {
                logger.debug("Error caught when trying to add bridge address consumer to management", (Throwable)e);
            }
            this.topUpCreditIfNeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
            try {
                Message theMessage;
                if (logger.isTraceEnabled()) {
                    logger.trace("AMQP Bridge {} address receiver {} dispatching incoming message: {}", new Object[]{AMQPBridgeFromAddressReceiver.this.bridgeManager.getName(), AMQPBridgeFromAddressReceiver.this.receiverInfo, message});
                }
                if ((theMessage = AMQPBridgeFromAddressReceiver.this.transformer.transform(message)) != message && logger.isTraceEnabled()) {
                    logger.trace("The transformer {} replaced the original message {} with a new instance {}", new Object[]{AMQPBridgeFromAddressReceiver.this.transformer, message, theMessage});
                }
                this.sessionSPI.serverSend(this, tx, receiver, delivery, this.cachedAddress, this.routingContext, theMessage);
            }
            catch (Exception e) {
                logger.warn("Inbound delivery for {} encountered an error: {}", new Object[]{AMQPBridgeFromAddressReceiver.this.receiverInfo, e.getMessage(), e});
                this.deliveryFailed(delivery, receiver, e);
            }
            finally {
                AMQPBridgeFromAddressReceiver.this.recordMessageReceived(message);
            }
        }
    }
}

