/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceRegistration;
import org.jboss.as.clustering.infinispan.transport.ChannelConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class JGroupsTransportResourceDefinitionRegistrar
extends TransportResourceDefinitionRegistrar {
    static final UnaryServiceDescriptor<Void> JGROUPS = UnaryServiceDescriptor.of((String)String.join((CharSequence)".", InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION.getName(), TransportResourceRegistration.JGROUPS.getPathElement().getKey(), TransportResourceRegistration.JGROUPS.getPathElement().getValue()), Void.class);
    private static final RuntimeCapability<Void> JGROUPS_CAPABILITY = RuntimeCapability.Builder.of(JGROUPS).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    static final CapabilityReferenceAttributeDefinition<ForkChannelFactory> CHANNEL_FACTORY = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("channel", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)ForkChannelFactory.SERVICE_DESCRIPTOR).build()).setRequired(false)).build();
    static final DurationAttributeDefinition LOCK_TIMEOUT = new DurationAttributeDefinition.Builder("lock-timeout", ChronoUnit.MILLIS).setDefaultValue(Duration.ofMinutes(4L)).build();

    JGroupsTransportResourceDefinitionRegistrar() {
        super(new TransportResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return TransportResourceRegistration.JGROUPS;
            }

            public String resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                return CHANNEL_FACTORY.resolveModelAttribute(context, model).asStringOrNull();
            }

            @Override
            public CapabilityServiceInstaller.Builder<TransportConfiguration, TransportConfiguration> apply(CapabilityServiceInstaller.Builder<TransportConfiguration, TransportConfiguration> builder) {
                return (CapabilityServiceInstaller.Builder)builder.startWhen(Installer.StartWhen.AVAILABLE);
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(CHANNEL_FACTORY, LOCK_TIMEOUT))).addCapability(JGROUPS_CAPABILITY)).addResourceCapabilityReference(ResourceCapabilityReference.builder(JGROUPS_CAPABILITY, (NullaryServiceDescriptor)ForkChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).build());
    }

    public ServiceDependency<TransportConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String containerName = context.getCurrentAddress().getParent().getLastElement().getValue();
        final Duration lockTimeout = LOCK_TIMEOUT.resolve(context, model);
        return CHANNEL_FACTORY.resolve(context, model).map((Function)new Function<ForkChannelFactory, TransportConfigurationBuilder>(){

            @Override
            public TransportConfigurationBuilder apply(ForkChannelFactory factory) {
                Properties properties = new Properties();
                properties.put("channelConfigurator", new ChannelConfigurator((ChannelFactory)factory, containerName));
                ForkChannelFactoryConfiguration configuration = factory.getConfiguration();
                TransportConfiguration.Topology topology = configuration.getTransport().getTopology();
                TransportConfigurationBuilder builder = new GlobalConfigurationBuilder().transport().clusterName(configuration.getChannelConfiguration().getClusterName()).distributedSyncTimeout(lockTimeout.toMillis(), TimeUnit.MILLISECONDS).transport((Transport)new JGroupsTransport()).withProperties(properties);
                if (topology != null) {
                    builder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
                }
                return builder;
            }
        });
    }
}

