/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.controller.PropertiesAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.PersistenceResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteThroughResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.Dependency;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.service.ServiceDependency;

public class StoreResourceDefinitionRegistrar<C extends StoreConfiguration, B extends StoreConfigurationBuilder<C, B>>
extends PersistenceResourceDefinitionRegistrar {
    static final PropertiesAttributeDefinition PROPERTIES = new PropertiesAttributeDefinition.Builder().build();
    private final ResourceModelResolver<ServiceDependency<B>> storeResolver;

    StoreResourceDefinitionRegistrar(Configurator<C, B> configurator) {
        super(configurator);
        this.storeResolver = configurator;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(PROPERTIES))).provideAttributes(EnumSet.allOf(Attribute.class))).provideAttributes(EnumSet.allOf(DeprecatedAttribute.class))).requireSingletonChildResource((ResourceRegistration)StoreWriteResourceRegistration.THROUGH);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new StoreWriteBehindResourceDefinitionRegistrar().register(registration, context);
        new StoreWriteThroughResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    public ServiceDependency<PersistenceConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress storeAddress = context.getCurrentAddress();
        PathAddress cacheAddress = storeAddress.getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)containerAddress.getLastElement().getValue(), (String)cacheAddress.getLastElement().getValue());
        ServiceDependency async = configuration.getServiceDependency(StoreWriteResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        final boolean passivation = Attribute.PASSIVATION.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean preload = Attribute.PRELOAD.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean purge = Attribute.PURGE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean segmented = Attribute.SEGMENTED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean shared = Attribute.SHARED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final int maxBatchSize = Attribute.MAX_BATCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final Map properties = PROPERTIES.resolve(context, model);
        return ((ServiceDependency)this.storeResolver.resolve(context, model)).combine((Dependency)async, new BiFunction<B, AsyncStoreConfiguration, PersistenceConfigurationBuilder>(){

            @Override
            public PersistenceConfigurationBuilder apply(B builder, AsyncStoreConfiguration async) {
                ((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)builder.maxBatchSize(maxBatchSize)).preload(preload)).purgeOnStartup(purge)).segmented(segmented)).shared(shared);
                for (Map.Entry entry : properties.entrySet()) {
                    builder.addProperty((String)entry.getKey(), (String)entry.getValue());
                }
                builder.async().read((Object)async);
                return builder.persistence().passivation(passivation);
            }
        });
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        MAX_BATCH_SIZE("max-batch-size", ModelType.INT, new ModelNode(100)),
        PASSIVATION("passivation", ModelType.BOOLEAN, ModelNode.FALSE),
        PRELOAD("preload", ModelType.BOOLEAN, ModelNode.FALSE),
        PURGE("purge", ModelType.BOOLEAN, ModelNode.FALSE),
        SHARED("shared", ModelType.BOOLEAN, ModelNode.FALSE),
        SEGMENTED("segmented", ModelType.BOOLEAN, ModelNode.TRUE);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }

    static enum DeprecatedAttribute implements AttributeDefinitionProvider
    {
        FETCH_STATE("fetch-state", ModelType.BOOLEAN, ModelNode.TRUE, InfinispanSubsystemModel.VERSION_16_0_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModelNode defaultValue, InfinispanSubsystemModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }

    static interface Configurator<C extends StoreConfiguration, B extends StoreConfigurationBuilder<C, B>>
    extends PersistenceResourceDefinitionRegistrar.Configurator,
    ResourceModelResolver<ServiceDependency<B>> {
    }
}

