/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.ChannelPipeline;
import jakarta.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.xa.XAResource;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.counter.impl.RemoteCounterManager;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheManagerAdminImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.DefaultCacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.ManagerOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.ObjectRoutingCacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.ServerRoutingCacheOperationsFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transaction.SyncModeTransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transaction.XaModeTransactionTable;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.jmx.RemoteCacheManagerMXBean;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.BytesOnlyMarshaller;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryServiceFactory;
import org.infinispan.client.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.marshall.UserContextInitializerImpl;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Version;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

public class RemoteCacheManager
implements RemoteCacheContainer,
Closeable,
RemoteCacheManagerMXBean {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    public static final String JSON_STRING_ARRAY_ELEMENT_REGEX = "(?:\")([^\"]*)(?:\",?)";
    private volatile boolean started = false;
    private final Map<RemoteCacheKey, InternalRemoteCache<?, ?>> cacheName2RemoteCache = new HashMap();
    private final MarshallerRegistry marshallerRegistry = new MarshallerRegistry();
    private final Configuration configuration;
    private final TelemetryService telemetryService;
    private Marshaller marshaller;
    protected OperationDispatcher dispatcher;
    protected ClientListenerNotifier listenerNotifier;
    private final Runnable start = this::start;
    private final Runnable stop = this::stop;
    private final RemoteCounterManager counterManager;
    private final TransactionTable syncTransactionTable;
    private final XaModeTransactionTable xaTransactionTable;
    private ObjectName mbeanObjectName;
    private final TimeService timeService = DefaultTimeService.INSTANCE;
    private ExecutorService asyncExecutorService;
    private final ManagerOperationsFactory managerOpFactory = ManagerOperationsFactory.getInstance();

    public RemoteCacheManager(Configuration configuration) {
        this(configuration, true);
    }

    public RemoteCacheManager(String uri) {
        this(HotRodURI.create(uri));
    }

    public RemoteCacheManager(URI uri) {
        this(HotRodURI.create(uri));
    }

    private RemoteCacheManager(HotRodURI uri) {
        this(uri.toConfigurationBuilder().build());
    }

    public RemoteCacheManager(Configuration configuration, boolean start) {
        this.configuration = configuration;
        this.telemetryService = TelemetryServiceFactory.telemetryService(configuration.tracingPropagationEnabled());
        this.counterManager = new RemoteCounterManager();
        this.syncTransactionTable = new SyncModeTransactionTable(configuration.transactionTimeout());
        this.xaTransactionTable = new XaModeTransactionTable(configuration.transactionTimeout());
        this.registerMBean();
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, cl);
        if (stream == null) {
            Log.HOTROD.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
        } else {
            try {
                builder.withProperties(this.loadFromStream(stream));
            }
            finally {
                org.infinispan.commons.util.Util.close((AutoCloseable)stream);
            }
        }
        this.configuration = builder.build();
        this.telemetryService = TelemetryServiceFactory.telemetryService(this.configuration.tracingPropagationEnabled());
        this.counterManager = new RemoteCounterManager();
        this.syncTransactionTable = new SyncModeTransactionTable(this.configuration.transactionTimeout());
        this.xaTransactionTable = new XaModeTransactionTable(this.configuration.transactionTimeout());
        this.registerMBean();
        if (start) {
            this.actualStart();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    private void registerMBean() {
        StatisticsConfiguration configuration = this.configuration.statistics();
        if (configuration.jmxEnabled()) {
            try {
                MBeanServer mbeanServer = configuration.mbeanServerLookup().getMBeanServer();
                this.mbeanObjectName = new ObjectName(String.format("%s:type=HotRodClient,name=%s", configuration.jmxDomain(), configuration.jmxName()));
                mbeanServer.registerMBean(this, this.mbeanObjectName);
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxRegistrationFailure(e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.mbeanObjectName != null) {
            try {
                MBeanServer mBeanServer = this.configuration.statistics().mbeanServerLookup().getMBeanServer();
                if (mBeanServer.isRegistered(this.mbeanObjectName)) {
                    mBeanServer.unregisterMBean(this.mbeanObjectName);
                } else {
                    Log.HOTROD.debugf("MBean not registered: %s", this.mbeanObjectName);
                }
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxUnregistrationFailure(e);
            }
        }
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.configuration.forceReturnValues(), null, null);
    }

    public Set<String> getCacheNames() {
        HotRodOperation<String> executeOp = this.managerOpFactory.executeOperation("@@cache@names", Collections.emptyMap());
        String names = Util.await(this.dispatcher.execute(executeOp));
        TreeSet<String> cacheNames = new TreeSet<String>();
        Pattern pattern = Pattern.compile(JSON_STRING_ARRAY_ELEMENT_REGEX);
        Matcher matcher = pattern.matcher(names);
        while (matcher.find()) {
            cacheNames.add(matcher.group(1));
        }
        return cacheNames;
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.configuration.forceReturnValues());
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, TransactionMode transactionMode, TransactionManager transactionManager) {
        return this.createRemoteCache(cacheName, this.configuration.forceReturnValues(), transactionMode, transactionManager);
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue, TransactionMode transactionMode, TransactionManager transactionManager) {
        return this.createRemoteCache(cacheName, forceReturnValue, transactionMode, transactionManager);
    }

    private <K, V> InternalRemoteCache<K, V> getInternalCache(String cacheName) {
        return this.createRemoteCache(cacheName, this.configuration.forceReturnValues(), null, null);
    }

    public CompletableFuture<Void> startAsync() {
        return CompletableFuture.runAsync(this.start, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> stopAsync() {
        return CompletableFuture.runAsync(this.stop, ForkJoinPool.commonPool());
    }

    public void start() {
        if (!this.started) {
            this.actualStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualStart() {
        log.debugf("Starting remote cache manager %x", System.identityHashCode(this));
        this.marshallerRegistry.registerMarshaller(BytesOnlyMarshaller.INSTANCE);
        this.marshallerRegistry.registerMarshaller((Marshaller)new UTF8StringMarshaller());
        this.marshallerRegistry.registerMarshaller((Marshaller)new JavaSerializationMarshaller(this.configuration.getClassAllowList()));
        this.registerProtoStreamMarshaller();
        boolean customMarshallerInstance = true;
        this.marshaller = this.configuration.marshaller();
        if (this.marshaller == null) {
            Class<? extends Marshaller> clazz = this.configuration.marshallerClass();
            this.marshaller = this.marshallerRegistry.getMarshaller(clazz);
            if (this.marshaller == null) {
                this.marshaller = (Marshaller)org.infinispan.commons.util.Util.getInstance(clazz);
            } else {
                customMarshallerInstance = false;
            }
        }
        if (customMarshallerInstance) {
            if (!this.configuration.serialAllowList().isEmpty()) {
                this.marshaller.initialize(this.configuration.getClassAllowList());
            }
            if (this.marshaller instanceof ProtoStreamMarshaller) {
                this.initializeProtoStreamMarshaller((ProtoStreamMarshaller)this.marshaller);
            }
            this.marshallerRegistry.registerMarshaller(this.marshaller);
        }
        this.listenerNotifier = new ClientListenerNotifier(this.marshaller, this.configuration);
        ExecutorFactory executorFactory = this.configuration.asyncExecutorFactory().factory();
        if (executorFactory == null) {
            executorFactory = (ExecutorFactory)org.infinispan.commons.util.Util.getInstance(this.configuration.asyncExecutorFactory().factoryClass());
        }
        this.asyncExecutorService = executorFactory.getExecutor((Properties)this.configuration.asyncExecutorFactory().properties());
        this.dispatcher = new OperationDispatcher(this.configuration, this.asyncExecutorService, this.timeService, this.listenerNotifier, this.pipelineWrapper());
        this.counterManager.start(this.dispatcher, this.listenerNotifier);
        this.dispatcher.start();
        this.syncTransactionTable.start(this.managerOpFactory, this.dispatcher);
        this.xaTransactionTable.start(this.managerOpFactory, this.dispatcher);
        Map<RemoteCacheKey, InternalRemoteCache<?, ?>> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (InternalRemoteCache<?, ?> cache : this.cacheName2RemoteCache.values()) {
                this.dispatcher.addCacheTopologyInfoIfAbsent(cache.getName());
            }
        }
        Log.HOTROD.version(Version.printVersion());
        this.started = true;
    }

    protected Consumer<ChannelPipeline> pipelineWrapper() {
        return pipeline -> {};
    }

    private void registerProtoStreamMarshaller() {
        try {
            ProtoStreamMarshaller protoMarshaller = new ProtoStreamMarshaller();
            this.marshallerRegistry.registerMarshaller((Marshaller)protoMarshaller);
            this.initializeProtoStreamMarshaller(protoMarshaller);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void initializeProtoStreamMarshaller(ProtoStreamMarshaller protoMarshaller) {
        SerializationContext ctx = protoMarshaller.getSerializationContext();
        RemoteCacheManager.registerDefaultSchemas(ctx, "org.infinispan.protostream.types.java.CommonContainerTypesSchema", "org.infinispan.protostream.types.java.CommonTypesSchema");
        RemoteCacheManager.registerSerializationContextInitializer(ctx, (SerializationContextInitializer)new UserContextInitializerImpl());
        for (SerializationContextInitializer sci : this.configuration.getContextInitializers()) {
            RemoteCacheManager.registerSerializationContextInitializer(ctx, sci);
        }
    }

    private static void registerSerializationContextInitializer(SerializationContext ctx, SerializationContextInitializer sci) {
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
    }

    private static void registerDefaultSchemas(SerializationContext ctx, String ... classNames) {
        for (String className : classNames) {
            SerializationContextInitializer sci;
            try {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                sci = (SerializationContextInitializer)instance;
            }
            catch (Exception e) {
                log.failedToCreatePredefinedSerializationContextInitializer(className, e);
                continue;
            }
            RemoteCacheManager.registerSerializationContextInitializer(ctx, sci);
        }
    }

    @Override
    public boolean isTransactional(String cacheName) {
        return Util.checkTransactionSupport(cacheName, this.managerOpFactory, this.dispatcher, log);
    }

    public MarshallerRegistry getMarshallerRegistry() {
        return this.marshallerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isStarted()) {
            log.debugf("Stopping remote cache manager %x", System.identityHashCode(this));
            Map<RemoteCacheKey, InternalRemoteCache<?, ?>> map = this.cacheName2RemoteCache;
            synchronized (map) {
                for (Map.Entry<RemoteCacheKey, InternalRemoteCache<?, ?>> cache : this.cacheName2RemoteCache.entrySet()) {
                    cache.getValue().stop();
                }
                this.cacheName2RemoteCache.clear();
            }
            this.listenerNotifier.stop();
            this.counterManager.stop();
            this.dispatcher.stop();
            this.asyncExecutorService.shutdown();
        }
        this.unregisterMBean();
        this.configuration.metricRegistry().close();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean switchToCluster(String clusterName) {
        return this.dispatcher.manualSwitchToCluster(clusterName);
    }

    @Override
    public boolean switchToDefaultCluster() {
        return this.dispatcher.manualSwitchToCluster("___DEFAULT-CLUSTER___");
    }

    @Override
    public String getCurrentClusterName() {
        return this.dispatcher.getCurrentClusterName();
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        return properties;
    }

    private RemoteCacheConfiguration findConfiguration(String cacheName) {
        if (this.configuration.remoteCaches().containsKey(cacheName)) {
            return this.configuration.remoteCaches().get(cacheName);
        }
        for (Map.Entry<String, RemoteCacheConfiguration> c : this.configuration.remoteCaches().entrySet()) {
            String key = c.getKey();
            if (!GlobUtils.isGlob((String)key) || !cacheName.matches(GlobUtils.globToRegex((String)key))) continue;
            return c.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> InternalRemoteCache<K, V> createRemoteCache(String cacheName, boolean forceReturnValueOverride, TransactionMode transactionModeOverride, TransactionManager transactionManagerOverride) {
        InternalRemoteCache remoteCache;
        PingResponse pingResponse;
        RemoteCacheConfiguration cacheConfiguration = this.findConfiguration(cacheName);
        boolean configForceReturnValue = cacheConfiguration != null ? cacheConfiguration.forceReturnValues() : this.configuration.forceReturnValues();
        boolean forceReturnValue = forceReturnValueOverride || configForceReturnValue;
        RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValue);
        if (this.cacheName2RemoteCache.containsKey(key)) {
            return this.cacheName2RemoteCache.get(key);
        }
        if (this.started) {
            this.dispatcher.addCacheTopologyInfoIfAbsent(cacheName);
            HotRodOperation<PingResponse> op = this.managerOpFactory.newPingOperation(cacheName);
            pingResponse = Util.await(this.dispatcher.execute(op));
            if (pingResponse.isCacheNotFound()) {
                HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
                params.put("name", cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                if (cacheConfiguration != null && cacheConfiguration.templateName() != null) {
                    String templateName = cacheConfiguration.templateName();
                    params.put("template", templateName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                    log.tracef("Cache %s not found on the server, will create from template %s", cacheName, templateName);
                } else if (cacheConfiguration != null && cacheConfiguration.configuration() != null) {
                    String configuration = new StringConfiguration(cacheConfiguration.configuration()).toStringConfiguration(cacheName);
                    params.put("configuration", configuration.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                    log.tracef("Cache %s not found on the server, will create it with configuration %s", cacheName, configuration);
                } else {
                    return null;
                }
                HotRodOperation<String> createCacheOp = this.managerOpFactory.executeOperation("@@cache@getorcreate", params);
                Util.await(this.dispatcher.execute(createCacheOp));
                HotRodOperation<PingResponse> pingcacheOp = this.managerOpFactory.newPingOperation(cacheName);
                pingResponse = Util.await(this.dispatcher.execute(pingcacheOp));
            }
        } else {
            pingResponse = PingResponse.EMPTY;
        }
        Function factoryFunction = DefaultCacheOperationsFactory::new;
        if (this.telemetryService != null) {
            factoryFunction = this.telemetryService.wrapWithTelemetry(factoryFunction);
        }
        if (this.configuration.statistics().enabled()) {
            factoryFunction = ClientStatistics.functionFor(factoryFunction);
        }
        if (pingResponse.getKeyMediaType() == MediaType.APPLICATION_OBJECT) {
            factoryFunction = RemoteCacheManager.wrapWithRouting(factoryFunction);
        } else if (pingResponse.getKeyMediaType() != MediaType.APPLICATION_UNKNOWN) {
            factoryFunction = RemoteCacheManager.wrapWithServerRouting(factoryFunction);
        }
        TransactionMode transactionMode = this.getTransactionMode(transactionModeOverride, cacheConfiguration);
        if (transactionMode == TransactionMode.NONE) {
            remoteCache = this.createRemoteCache(cacheName, cacheConfiguration, factoryFunction);
        } else {
            if (!Util.await(Util.checkTransactionSupport(cacheName, this.managerOpFactory, this.dispatcher).toCompletableFuture()).booleanValue()) {
                throw Log.HOTROD.cacheDoesNotSupportTransactions(cacheName);
            }
            TransactionManager transactionManager = this.getTransactionManager(transactionManagerOverride, cacheConfiguration);
            remoteCache = this.createRemoteTransactionalCache(cacheName, factoryFunction, transactionMode == TransactionMode.FULL_XA, transactionMode, transactionManager);
        }
        Map<RemoteCacheKey, InternalRemoteCache<?, ?>> map = this.cacheName2RemoteCache;
        synchronized (map) {
            this.startRemoteCache(remoteCache);
            remoteCache.resolveStorage(pingResponse.getKeyMediaType(), pingResponse.getValueMediaType());
            if (!configForceReturnValue) {
                this.cacheName2RemoteCache.putIfAbsent(new RemoteCacheKey(cacheName, false), remoteCache);
            }
            InternalRemoteCache forceReturn = remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
            this.cacheName2RemoteCache.putIfAbsent(new RemoteCacheKey(cacheName, true), forceReturn);
            return forceReturnValue ? forceReturn : remoteCache;
        }
    }

    static <K, V> Function<InternalRemoteCache<K, V>, CacheOperationsFactory> wrapWithServerRouting(Function<InternalRemoteCache<K, V>, CacheOperationsFactory> factoryFunction) {
        return irc -> new ServerRoutingCacheOperationsFactory((CacheOperationsFactory)factoryFunction.apply((InternalRemoteCache)irc));
    }

    static <K, V> Function<InternalRemoteCache<K, V>, CacheOperationsFactory> wrapWithRouting(Function<InternalRemoteCache<K, V>, CacheOperationsFactory> factoryFunction) {
        return irc -> new ObjectRoutingCacheOperationsFactory((CacheOperationsFactory)factoryFunction.apply((InternalRemoteCache)irc));
    }

    private <K, V> InternalRemoteCache<K, V> createRemoteCache(String cacheName, RemoteCacheConfiguration remoteCacheConfiguration, Function<InternalRemoteCache<K, V>, CacheOperationsFactory> factoryFunction) {
        Pattern pattern;
        NearCacheConfiguration nearCache = remoteCacheConfiguration != null ? new NearCacheConfiguration(remoteCacheConfiguration.nearCacheMode(), remoteCacheConfiguration.nearCacheMaxEntries(), remoteCacheConfiguration.nearCacheBloomFilter(), null, remoteCacheConfiguration.nearCacheFactory()) : ((pattern = this.configuration.nearCache().cacheNamePattern()) == null || pattern.matcher(cacheName).matches() ? this.configuration.nearCache() : new NearCacheConfiguration(NearCacheMode.DISABLED, -1, false));
        if (nearCache.mode() == NearCacheMode.INVALIDATED && ((pattern = nearCache.cacheNamePattern()) == null || pattern.matcher(cacheName).matches())) {
            if (log.isTraceEnabled()) {
                log.tracef("Enabling near-caching for cache '%s'", cacheName);
            }
            NearCacheService<K, V> nearCacheService = this.createNearCacheService(cacheName, nearCache);
            return InvalidatedNearRemoteCache.delegatingNearCache(new RemoteCacheImpl<K, V>(this, cacheName, this.timeService, nearCacheService, factoryFunction), nearCacheService);
        }
        return new RemoteCacheImpl<K, V>(this, cacheName, this.timeService, factoryFunction);
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(String cacheName, NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    private void startRemoteCache(InternalRemoteCache<?, ?> remoteCache) {
        this.initRemoteCache(remoteCache);
        remoteCache.start();
    }

    private void initRemoteCache(InternalRemoteCache<?, ?> remoteCache) {
        if (this.configuration.statistics().jmxEnabled()) {
            remoteCache.init(this.configuration, this.dispatcher, this.mbeanObjectName);
        } else {
            remoteCache.init(this.configuration, this.dispatcher);
        }
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }

    public RemoteCacheManagerAdmin administration() {
        return new RemoteCacheManagerAdminImpl(this, this.managerOpFactory, this.dispatcher, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), name -> {
            Map<RemoteCacheKey, InternalRemoteCache<?, ?>> map = this.cacheName2RemoteCache;
            synchronized (map) {
                InternalRemoteCache<?, ?> removed = this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, true));
                if (removed != null) {
                    removed.stop();
                }
                if ((removed = this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, false))) != null) {
                    removed.stop();
                }
            }
        });
    }

    @Override
    public void close() {
        this.stop();
    }

    CounterManager getCounterManager() {
        return this.counterManager;
    }

    protected OperationDispatcher getOperationDispatcher() {
        return this.dispatcher;
    }

    public XAResource getXaResource() {
        return this.xaTransactionTable.getXaResource();
    }

    private TransactionManager getTransactionManager(TransactionManager override, RemoteCacheConfiguration cacheConfiguration) {
        try {
            return override == null ? (cacheConfiguration == null ? GenericTransactionManagerLookup.getInstance().getTransactionManager() : cacheConfiguration.transactionManagerLookup().getTransactionManager()) : override;
        }
        catch (Exception e) {
            throw new HotRodClientException(e);
        }
    }

    private TransactionMode getTransactionMode(TransactionMode override, RemoteCacheConfiguration cacheConfiguration) {
        return override == null ? (cacheConfiguration == null ? TransactionMode.NONE : cacheConfiguration.transactionMode()) : override;
    }

    private TransactionTable getTransactionTable(TransactionMode transactionMode) {
        switch (transactionMode) {
            case NON_XA: {
                return this.syncTransactionTable;
            }
            case NON_DURABLE_XA: 
            case FULL_XA: {
                return this.xaTransactionTable;
            }
        }
        throw new IllegalStateException();
    }

    private <K, V> TransactionalRemoteCacheImpl<K, V> createRemoteTransactionalCache(String cacheName, Function<InternalRemoteCache<K, V>, CacheOperationsFactory> factoryFunction, boolean recoveryEnabled, TransactionMode transactionMode, TransactionManager transactionManager) {
        return new TransactionalRemoteCacheImpl<K, V>(this, cacheName, recoveryEnabled, transactionManager, this.getTransactionTable(transactionMode), this.timeService, factoryFunction);
    }

    @Override
    public String[] getServers() {
        Collection<InetSocketAddress> addresses = this.dispatcher.getServers();
        return (String[])addresses.stream().map(socketAddress -> socketAddress.getHostString() + ":" + socketAddress.getPort()).toArray(String[]::new);
    }

    @Override
    public int getActiveConnectionCount() {
        return -1;
    }

    @Override
    public int getConnectionCount() {
        return this.dispatcher.getServers().size();
    }

    @Override
    public int getIdleConnectionCount() {
        return -1;
    }

    @Override
    public long getRetries() {
        return this.dispatcher.getRetries();
    }

    public ExecutorService getAsyncExecutorService() {
        return this.asyncExecutorService;
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    private record RemoteCacheKey(String cacheName, boolean forceReturnValue) {
    }
}

