/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import org.jboss.as.platform.mbean.AbstractExtendedMBean;

class ExtendedThreadMBean
extends AbstractExtendedMBean {
    static final String THREAD_ALLOCATED_MEMORY_ENABLED_ATTRIBUTE = "ThreadAllocatedMemoryEnabled";
    static final String THREAD_ALLOCATED_MEMORY_SUPPORTED_ATTRIBUTE = "ThreadAllocatedMemorySupported";
    static final String CURRENT_THREAD_ALLOCATED_BYTES_ATTRIBUTE = "CurrentThreadAllocatedBytes";
    static final String GET_THREAD_CPU_TIME = "getThreadCpuTime";
    static final String GET_THREAD_ALLOCATED_BYTES = "getThreadAllocatedBytes";
    static final String GET_THREAD_USER_TIME = "getThreadUserTime";

    ExtendedThreadMBean() {
        super("java.lang:type=Threading");
    }

    long getCurrentThreadAllocatedBytes() {
        return (Long)this.getAttribute(CURRENT_THREAD_ALLOCATED_BYTES_ATTRIBUTE);
    }

    boolean isThreadAllocatedMemoryEnabled() {
        return (Boolean)this.getAttribute(THREAD_ALLOCATED_MEMORY_ENABLED_ATTRIBUTE);
    }

    boolean isThreadAllocatedMemorySupported() {
        return (Boolean)this.getAttribute(THREAD_ALLOCATED_MEMORY_SUPPORTED_ATTRIBUTE);
    }

    void setThreadAllocatedMemoryEnabled(boolean value) {
        this.setAttribute(THREAD_ALLOCATED_MEMORY_ENABLED_ATTRIBUTE, value);
    }

    long[] getThreadCpuTime(long[] ids) {
        return (long[])this.invokeOperation(GET_THREAD_CPU_TIME, new Object[]{ids}, new String[]{long[].class.getName()});
    }

    long getThreadAllocatedBytes(long id) {
        return (Long)this.invokeOperation(GET_THREAD_ALLOCATED_BYTES, new Object[]{id}, new String[]{Long.TYPE.getName()});
    }

    long[] getThreadAllocatedBytes(long[] id) {
        return (long[])this.invokeOperation(GET_THREAD_ALLOCATED_BYTES, new Object[]{id}, new String[]{long[].class.getName()});
    }

    long[] getThreadUserTime(long[] ids) {
        return (long[])this.invokeOperation(GET_THREAD_USER_TIME, new Object[]{ids}, new String[]{long[].class.getName()});
    }
}

