/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.jgroups;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.wildfly.clustering.server.GroupMembership;
import org.wildfly.clustering.server.GroupMembershipEvent;
import org.wildfly.clustering.server.GroupMembershipListener;
import org.wildfly.clustering.server.GroupMembershipMergeEvent;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ChannelGroupMemberFactory;
import org.wildfly.clustering.server.jgroups.JChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ViewMembership;
import org.wildfly.clustering.server.listener.ListenerRegistrar;
import org.wildfly.clustering.server.local.listener.LocalListenerRegistrar;

public class JChannelGroup
implements ChannelGroup,
Receiver {
    private static final System.Logger LOGGER = System.getLogger(JChannelGroup.class.getName());
    private final JChannel channel;
    private final ChannelGroupMemberFactory memberFactory = JChannelGroupMember::new;
    private final ChannelGroupMember localMember;
    private final ListenerRegistrar<GroupMembershipListener<ChannelGroupMember>> listeners;
    private final AtomicReference<View> view = new AtomicReference();

    public JChannelGroup(JChannel channel) {
        this.channel = channel;
        this.localMember = (ChannelGroupMember)this.memberFactory.createGroupMember((Comparable)channel.getAddress());
        this.listeners = new LocalListenerRegistrar(Duration.ofMillis(channel.getProtocolStack().getTransport().getWhoHasCacheTimeout()));
        channel.setReceiver((Receiver)this);
        this.view.compareAndSet(null, channel.getView());
    }

    @Override
    public JChannel getChannel() {
        return this.channel;
    }

    public Registration register(GroupMembershipListener<ChannelGroupMember> listener) {
        return this.listeners.register(listener);
    }

    public org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> getMembership() {
        return new ViewMembership(this.view.get(), this.memberFactory);
    }

    public ChannelGroupMember getLocalMember() {
        return this.localMember;
    }

    @Override
    public ChannelGroupMemberFactory getGroupMemberFactory() {
        return this.memberFactory;
    }

    public void viewAccepted(View view) {
        try {
            View previousView = this.view.getAndSet(view);
            if (previousView != null) {
                if (view instanceof MergeView) {
                    MergeView mergeView = (MergeView)view;
                    DefaultGroupMembershipMergeEvent event = new DefaultGroupMembershipMergeEvent(previousView, mergeView);
                    this.listeners.accept(listener -> listener.merged(event));
                } else {
                    List leavers = View.leftMembers((View)previousView, (View)view);
                    DefaultGroupMembershipEvent event = new DefaultGroupMembershipEvent(previousView, view);
                    this.listeners.accept(listener -> {
                        if (leavers.size() > 1) {
                            listener.split(event);
                        } else {
                            listener.updated(event);
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void close() {
        this.listeners.close();
    }

    org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> membership(View view) {
        return new ViewMembership(view, this.memberFactory);
    }

    private class DefaultGroupMembershipMergeEvent
    extends DefaultGroupMembershipEvent
    implements GroupMembershipMergeEvent<ChannelGroupMember> {
        private final List<GroupMembership<ChannelGroupMember>> partitions;

        DefaultGroupMembershipMergeEvent(View previousView, MergeView currentView) {
            super(previousView, (View)currentView);
            this.partitions = currentView.getSubgroups().stream().map(JChannelGroup.this::membership).collect(Collectors.toUnmodifiableList());
        }

        public List<GroupMembership<ChannelGroupMember>> getPartitions() {
            return this.partitions;
        }
    }

    private class DefaultGroupMembershipEvent
    implements GroupMembershipEvent<ChannelGroupMember> {
        private final org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> previousMembership;
        private final org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> currentMembership;

        DefaultGroupMembershipEvent(View previousView, View currentView) {
            this.previousMembership = JChannelGroup.this.membership(previousView);
            this.currentMembership = JChannelGroup.this.membership(currentView);
        }

        public org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> getPreviousMembership() {
            return this.previousMembership;
        }

        public org.wildfly.clustering.server.group.GroupMembership<ChannelGroupMember> getCurrentMembership() {
            return this.currentMembership;
        }
    }
}

