/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.vertx.AbstractVertxOptionsResourceDefinition;
import org.wildfly.extension.vertx.NamedVertxOptions;
import org.wildfly.extension.vertx.VertxConstants;
import org.wildfly.extension.vertx.VertxProxy;
import org.wildfly.extension.vertx.VertxProxyHolder;
import org.wildfly.extension.vertx.VertxResourceDefinition;
import org.wildfly.extension.vertx.logging.VertxLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class VertxProxyService
implements Service,
VertxConstants {
    private VertxProxy vertxProxy;
    private final String optionName;
    private final Supplier<NamedVertxOptions> optionsSupplier;
    final Consumer<VertxProxy> vertxProxytConsumer;

    static void installService(OperationContext context, String optionName) {
        CapabilityServiceBuilder vertxServiceBuilder = context.getCapabilityServiceTarget().addService();
        Consumer vertxProxytConsumer = vertxServiceBuilder.provides(VertxResourceDefinition.VERTX_RUNTIME_CAPABILITY);
        Supplier optionsSupplier = optionName == null ? () -> NamedVertxOptions.DEFAULT : vertxServiceBuilder.requiresCapability(AbstractVertxOptionsResourceDefinition.VERTX_OPTIONS_CAPABILITY.getName(), NamedVertxOptions.class, new String[]{optionName});
        VertxProxyService vertxProxyService = new VertxProxyService(optionName, optionsSupplier, vertxProxytConsumer);
        vertxServiceBuilder.setInstance((Service)vertxProxyService);
        vertxServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        vertxServiceBuilder.install();
    }

    public VertxProxyService(String optionName, Supplier<NamedVertxOptions> optionsSupplier, Consumer<VertxProxy> vertxProxytConsumer) {
        this.optionName = optionName;
        this.optionsSupplier = optionsSupplier;
        this.vertxProxytConsumer = vertxProxytConsumer;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.vertxProxy = new VertxProxy(this.optionName, this.createVertx());
            VertxProxyHolder.instance().instrument(this.vertxProxy);
        }
        catch (Exception e) {
            throw VertxLogger.VERTX_LOGGER.failedToStartVertxService(e);
        }
        this.vertxProxytConsumer.accept(this.vertxProxy);
    }

    private Vertx createVertx() {
        VertxOptions vertxOptions = this.optionsSupplier.get().getVertxOptions();
        if (vertxOptions == null) {
            vertxOptions = new VertxOptions();
        }
        return new VertxBuilder(vertxOptions).init().vertx();
    }

    public void stop(StopContext context) {
        VertxProxyHolder.instance().release();
        if (this.vertxProxy != null) {
            CompletableFuture closeFuture = (CompletableFuture)this.vertxProxy.getVertx().close().toCompletionStage();
            try {
                closeFuture.join();
                this.vertxProxy = null;
            }
            catch (Exception e) {
                VertxLogger.VERTX_LOGGER.errorWhenClosingVertx(e);
            }
        }
    }

    static {
        if (WildFlySecurityManager.getPropertyPrivileged((String)"vertx.disableDnsResolver", null) == null) {
            WildFlySecurityManager.setPropertyPrivileged((String)"vertx.disableDnsResolver", (String)"true");
        }
    }
}

