/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public interface OtlpMetricsSender {
    public void send(Request var1) throws Exception;

    public static class Request {
        @Nullable
        private final String address;
        private final Map<String, String> headers;
        private final byte[] metricsData;

        private Request(@Nullable String address, Map<String, String> headers, byte[] metricsData) {
            this.address = address;
            this.headers = headers;
            this.metricsData = metricsData;
        }

        @Nullable
        public String getAddress() {
            return this.address;
        }

        public byte[] getMetricsData() {
            return this.metricsData;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String toString() {
            return "OtlpMetricsSender.Request for address: " + this.address + ", headers: " + this.headers + ", metricsData: " + new String(this.metricsData, StandardCharsets.UTF_8);
        }

        public static Builder builder(byte[] metricsData) {
            return new Builder(metricsData);
        }

        public static class Builder {
            private final byte[] metricsData;
            @Nullable
            private String address;
            private Map<String, String> headers = Collections.emptyMap();

            private Builder(byte[] metricsData) {
                this.metricsData = Objects.requireNonNull(metricsData);
            }

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            public Request build() {
                return new Request(this.address, this.headers, this.metricsData);
            }
        }
    }
}

