/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNamedPredicateOptions;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeContributor;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexObjectFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexRootBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexValueFieldBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexValueFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNamedPredicate;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaNamedPredicateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinition;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;

abstract class AbstractLuceneIndexCompositeNodeBuilder
implements IndexCompositeNodeBuilder,
IndexSchemaBuildContext {
    protected final LuceneIndexCompositeNodeType.Builder typeBuilder;
    private final Map<String, LuceneIndexNodeContributor> fields = new LinkedHashMap<String, LuceneIndexNodeContributor>();
    private final Map<String, LuceneIndexNodeContributor> templates = new LinkedHashMap<String, LuceneIndexNodeContributor>();
    private final Set<String> namedPredicates = new LinkedHashSet<String>();

    protected AbstractLuceneIndexCompositeNodeBuilder(LuceneIndexCompositeNodeType.Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, TreeNodeInclusion inclusion, IndexFieldType<F> indexFieldType) {
        LuceneIndexValueFieldType luceneIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexValueFieldBuilder childBuilder = new LuceneIndexValueFieldBuilder(this, relativeFieldName, inclusion, luceneIndexFieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public IndexObjectFieldBuilder addObjectField(String relativeFieldName, TreeNodeInclusion inclusion, ObjectStructure structure) {
        LuceneIndexObjectFieldBuilder objectFieldBuilder = new LuceneIndexObjectFieldBuilder(this, relativeFieldName, inclusion, structure);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaNamedPredicateOptionsStep addNamedPredicate(String name, TreeNodeInclusion inclusion, PredicateDefinition definition) {
        this.putNamedPredicate(name);
        if (TreeNodeInclusion.INCLUDED.equals((Object)inclusion)) {
            this.typeBuilder.queryElementFactory(PredicateTypeKeys.named((String)name), new LuceneNamedPredicate.Factory(definition, name));
        }
        return new LuceneIndexNamedPredicateOptions<PredicateDefinition>(inclusion, definition);
    }

    public IndexSchemaNamedPredicateOptionsStep addNamedPredicate(String name, TreeNodeInclusion inclusion, TypedPredicateDefinition<?> definition) {
        this.putNamedPredicate(name);
        if (TreeNodeInclusion.INCLUDED.equals((Object)inclusion)) {
            this.typeBuilder.queryElementFactory(PredicateTypeKeys.named((String)name), new LuceneNamedPredicate.TypedFactory(definition, name));
        }
        return new LuceneIndexNamedPredicateOptions(inclusion, definition);
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addFieldTemplate(String templateName, TreeNodeInclusion inclusion, IndexFieldType<?> indexFieldType, String prefix) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexValueFieldType elasticsearchIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexValueFieldTemplateBuilder templateBuilder = new LuceneIndexValueFieldTemplateBuilder(this, prefixedTemplateName, inclusion, elasticsearchIndexFieldType, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addObjectFieldTemplate(String templateName, ObjectStructure structure, String prefix, TreeNodeInclusion inclusion) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexObjectFieldTemplateBuilder templateBuilder = new LuceneIndexObjectFieldTemplateBuilder(this, prefixedTemplateName, inclusion, structure, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public abstract LuceneIndexRootBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final void contributeChildren(LuceneIndexCompositeNode node, LuceneIndexNodeCollector collector, Map<String, LuceneIndexField> staticChildrenByNameForParent) {
        for (LuceneIndexNodeContributor contributor : this.fields.values()) {
            contributor.contribute(collector, node, staticChildrenByNameForParent);
        }
        for (LuceneIndexNodeContributor template : this.templates.values()) {
            template.contribute(collector, node, staticChildrenByNameForParent);
        }
    }

    private void putField(String name, LuceneIndexNodeContributor contributor) {
        LuceneIndexNodeContributor previous = this.fields.putIfAbsent(name, contributor);
        if (previous != null) {
            throw MappingLog.INSTANCE.indexSchemaNodeNameConflict(name, this.eventContext());
        }
    }

    private void putTemplate(String name, LuceneIndexNodeContributor contributor) {
        LuceneIndexNodeContributor previous = this.templates.putIfAbsent(name, contributor);
        if (previous != null) {
            throw MappingLog.INSTANCE.indexSchemaFieldTemplateNameConflict(name, this.eventContext());
        }
    }

    private void putNamedPredicate(String name) {
        if (!this.namedPredicates.add(name)) {
            throw MappingLog.INSTANCE.indexSchemaNamedPredicateNameConflict(name, this.eventContext());
        }
    }
}

