/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.ConfigurationLog;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.util.common.data.impl.HashFunction;
import org.hibernate.search.util.common.data.impl.HashTable;
import org.hibernate.search.util.common.data.impl.ModuloHashTable;
import org.hibernate.search.util.common.data.impl.SimpleHashFunction;

public class HashShardingStrategy
implements ShardingStrategy {
    public static final String NAME = "hash";
    private static final OptionalConfigurationProperty<Integer> NUMBER_OF_SHARDS = ConfigurationProperty.forKey((String)"number_of_shards").asIntegerStrictlyPositive().build();
    private HashTable<String> shardIds;

    @Override
    public void initialize(ShardingStrategyInitializationContext context) {
        int numberOfShards = (Integer)NUMBER_OF_SHARDS.getOrThrow(context.configurationPropertySource(), () -> ConfigurationLog.INSTANCE.missingPropertyValueForShardingStrategy(NAME));
        this.shardIds = new ModuloHashTable((HashFunction)SimpleHashFunction.INSTANCE, numberOfShards);
        LinkedHashSet<String> shardIdSet = new LinkedHashSet<String>();
        for (int i = 0; i < numberOfShards; ++i) {
            String shardId = String.valueOf(i);
            this.shardIds.set(i, (Object)shardId);
            shardIdSet.add(shardId);
        }
        context.shardIdentifiers(shardIdSet);
    }

    @Override
    public String toShardIdentifier(String documentId, String routingKey) {
        return this.toShardIdentifier(routingKey == null ? documentId : routingKey);
    }

    @Override
    public Set<String> toShardIdentifiers(Set<String> routingKeys) {
        LinkedHashSet<String> matchingShardIds = new LinkedHashSet<String>();
        for (String routingKey : routingKeys) {
            matchingShardIds.add(this.toShardIdentifier(routingKey));
        }
        return matchingShardIds;
    }

    private String toShardIdentifier(String routingKey) {
        return (String)this.shardIds.get((CharSequence)routingKey);
    }
}

