/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.highlighter.impl;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldHighlightProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterFragmenter;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.projection.ProjectionCollector;

class LuceneUnifiedSearchHighlighter
extends LuceneAbstractSearchHighlighter {
    private static final Comparator<TextFragment> SCORE_COMPARATOR = Comparator.comparingDouble(TextFragment::score).reversed();
    public static final LuceneUnifiedSearchHighlighter DEFAULTS = new LuceneUnifiedSearchHighlighter(BoundaryScannerType.SENTENCE);

    private LuceneUnifiedSearchHighlighter(BoundaryScannerType scannerType) {
        super(scannerType);
    }

    protected LuceneUnifiedSearchHighlighter(LuceneAbstractSearchHighlighter.Builder builder) {
        super(builder);
    }

    private LuceneUnifiedSearchHighlighter(Set<String> indexNames, char[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        super(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
        if (this.noMatchSize > 0 && this.noMatchSize != Integer.MAX_VALUE) {
            QueryLog.INSTANCE.unifiedHighlighterNoMatchSizeWarning(this.noMatchSize);
        }
    }

    @Override
    protected LuceneAbstractSearchHighlighter createHighlighterSameType(Set<String> indexNames, char[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        return new LuceneUnifiedSearchHighlighter(indexNames, boundaryChars, boundaryMaxScan, fragmentSize, noMatchSize, numberOfFragments, orderByScore, preTags, postTags, boundaryScannerType, boundaryScannerLocale, fragmenterType, phraseLimit, encoder);
    }

    @Override
    public LuceneAbstractSearchHighlighter withFallbackDefaults() {
        return this.withFallback(DEFAULTS);
    }

    @Override
    public <A, T> Values<A> createValues(String parentDocumentPath, String nestedDocumentPath, String absoluteFieldPath, Analyzer analyzer, ProjectionExtractContext context, ProjectionCollector<String, ?, A, T> collector) {
        return new UnifiedHighlighterValues<A, T>(parentDocumentPath, nestedDocumentPath, absoluteFieldPath, analyzer, context, collector);
    }

    @Override
    public SearchHighlighterType type() {
        return SearchHighlighterType.UNIFIED;
    }

    private final class UnifiedHighlighterValues<A, T>
    extends LuceneFieldHighlightProjection.HighlighterValues<A, T> {
        private final String[] fieldsIn;
        private final int[] maxPassagesIn;
        private final Query query;
        private final MultiValueUnifiedHighlighter highlighter;

        UnifiedHighlighterValues(String parentDocumentPath, String nestedDocumentPath, String field, Analyzer analyzer, ProjectionExtractContext context, ProjectionCollector<String, ?, A, T> collector) {
            super(parentDocumentPath, nestedDocumentPath, context.collectorExecutionContext(), collector);
            this.fieldsIn = new String[]{field};
            this.maxPassagesIn = new int[]{LuceneUnifiedSearchHighlighter.this.numberOfFragments};
            this.query = context.collectorExecutionContext().originalQuery();
            PassageFormatterWithEncoder formatter = new PassageFormatterWithEncoder((String)LuceneUnifiedSearchHighlighter.this.preTags.get(0), (String)LuceneUnifiedSearchHighlighter.this.postTags.get(0), LuceneUnifiedSearchHighlighter.this.encoder);
            this.highlighter = MultiValueUnifiedHighlighter.builder(context.collectorExecutionContext().getIndexSearcher(), analyzer).withFormatter(formatter).withBreakIterator(this::breakIterator).withMaxNoHighlightPassages(LuceneUnifiedSearchHighlighter.this.noMatchSize > 0 ? 1 : 0).build();
        }

        private BreakIterator breakIterator() {
            if (BoundaryScannerType.WORD.equals((Object)LuceneUnifiedSearchHighlighter.this.boundaryScannerType)) {
                return BreakIterator.getWordInstance(LuceneUnifiedSearchHighlighter.this.boundaryScannerLocale);
            }
            if (BoundaryScannerType.SENTENCE.equals((Object)LuceneUnifiedSearchHighlighter.this.boundaryScannerType)) {
                return BreakIterator.getSentenceInstance(LuceneUnifiedSearchHighlighter.this.boundaryScannerLocale);
            }
            throw QueryLog.INSTANCE.unsupportedBoundaryScannerType(LuceneUnifiedSearchHighlighter.this.getClass().getSimpleName(), LuceneUnifiedSearchHighlighter.this.boundaryScannerType);
        }

        @Override
        public List<String> highlight(int doc) throws IOException {
            List<TextFragment> highlights = this.highlighter.highlightField(this.fieldsIn, this.query, this.leafReaderContext.docBase + doc, this.maxPassagesIn);
            if (highlights == null) {
                return Collections.emptyList();
            }
            if (Boolean.TRUE.equals(LuceneUnifiedSearchHighlighter.this.orderByScore)) {
                highlights.sort(SCORE_COMPARATOR);
            }
            ArrayList<String> result = new ArrayList<String>(highlights.size());
            for (TextFragment highlight : highlights) {
                result.add(highlight.highlightedText());
            }
            return result;
        }
    }

    static class TextFragment {
        private final String highlightedText;
        private final float score;

        public TextFragment(String highlightedText, float score) {
            this.highlightedText = highlightedText;
            this.score = score;
        }

        public String highlightedText() {
            return this.highlightedText;
        }

        public float score() {
            return this.score;
        }
    }

    static class PassageFormatterWithEncoder
    extends PassageFormatter {
        private final String preTag;
        private final String postTag;
        private final Encoder encoder;

        public PassageFormatterWithEncoder(String preTag, String postTag, Encoder encoder) {
            this.preTag = preTag;
            this.postTag = postTag;
            this.encoder = encoder;
        }

        public List<TextFragment> format(Passage[] passages, String content) {
            ArrayList<TextFragment> result = new ArrayList<TextFragment>(passages.length);
            int pos = 0;
            for (Passage passage : passages) {
                StringBuilder sb = new StringBuilder();
                pos = passage.getStartOffset();
                int start = 0;
                for (int i = 0; i < passage.getNumMatches(); ++i) {
                    start = passage.getMatchStarts()[i];
                    assert (start >= pos && start < passage.getEndOffset());
                    this.append(sb, content, pos, start);
                    int end = passage.getMatchEnds()[i];
                    assert (end > start);
                    while (i + 1 < passage.getNumMatches() && passage.getMatchStarts()[i + 1] < end) {
                        end = passage.getMatchEnds()[++i];
                    }
                    end = Math.min(end, passage.getEndOffset());
                    sb.append(this.preTag);
                    this.append(sb, content, start, end);
                    sb.append(this.postTag);
                    pos = end;
                }
                this.append(sb, content, pos, Math.max(pos, passage.getEndOffset()));
                result.add(new TextFragment(sb.toString().trim(), passage.getScore()));
            }
            return result;
        }

        protected void append(StringBuilder dest, String content, int start, int end) {
            dest.append(this.encoder.encodeText(content.substring(start, end)));
        }
    }

    private static class MultiValueUnifiedHighlighter
    extends UnifiedHighlighter {
        private MultiValueUnifiedHighlighter(Builder builder) {
            super((UnifiedHighlighter.Builder)builder);
        }

        public List<TextFragment> highlightField(String[] fieldIn, Query query, int doc, int[] maxPassagesIn) throws IOException {
            assert (fieldIn.length == 1);
            return (List)((Object[])this.highlightFieldsAsObjects(fieldIn, query, new int[]{doc}, maxPassagesIn).get(fieldIn[0]))[0];
        }

        public static Builder builder(IndexSearcher searcher, Analyzer indexAnalyzer) {
            return new Builder(searcher, indexAnalyzer);
        }

        public static class Builder
        extends UnifiedHighlighter.Builder {
            public Builder(IndexSearcher searcher, Analyzer indexAnalyzer) {
                super(searcher, indexAnalyzer);
            }

            public Builder withBreakIterator(Supplier<BreakIterator> value) {
                super.withBreakIterator(value);
                return this;
            }

            public Builder withMaxNoHighlightPassages(int value) {
                super.withMaxNoHighlightPassages(value);
                return this;
            }

            public Builder withFormatter(PassageFormatter value) {
                super.withFormatter(value);
                return this;
            }

            public MultiValueUnifiedHighlighter build() {
                return new MultiValueUnifiedHighlighter(this);
            }
        }
    }
}

