/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNestedPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;

abstract class AbstractLuceneNestablePredicate
extends AbstractLuceneSearchPredicate {
    AbstractLuceneNestablePredicate(AbstractLuceneSearchPredicate.AbstractBuilder builder) {
        super(builder);
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        if (expectedParentNestedPath != null && !nestedPathHierarchy.contains(expectedParentNestedPath)) {
            throw QueryLog.INSTANCE.invalidNestedObjectPathForPredicate(this, expectedParentNestedPath, this.getFieldPathsForErrorMessage());
        }
    }

    @Override
    public final Query toQuery(PredicateRequestContext context) {
        int hierarchyLastIndex;
        String path;
        String expectedNestedPath;
        this.checkNestableWithin(context.getNestedPath());
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        String string = expectedNestedPath = nestedPathHierarchy.isEmpty() ? null : nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        if (Objects.equals(context.getNestedPath(), expectedNestedPath)) {
            return super.toQuery(context);
        }
        PredicateRequestContext contextAfterImplicitNesting = context.withNestedPath(expectedNestedPath);
        Query result = super.toQuery(contextAfterImplicitNesting);
        for (int i = hierarchyLastIndex = nestedPathHierarchy.size() - 1; i >= 0 && !(path = nestedPathHierarchy.get(i)).equals(context.getNestedPath()); --i) {
            String parentNestedDocumentPath = i == 0 ? null : nestedPathHierarchy.get(i - 1);
            result = LuceneNestedPredicate.createNestedQuery(parentNestedDocumentPath, path, result);
        }
        return result;
    }

    protected abstract List<String> getNestedPathHierarchy();

    protected abstract List<String> getFieldPathsForErrorMessage();
}

