/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexRoot;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.reporting.impl.LuceneSearchHints;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneSearchIndexScopeImpl;
import org.hibernate.search.backend.lucene.search.projection.dsl.DocumentTree;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneProjectionTypeKeys;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexCompositeNodeType;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;

class LuceneDocumentTreeProjection
extends AbstractLuceneProjection<DocumentTree>
implements LuceneSearchProjection.Extractor<DocumentTree, DocumentTree> {
    private final Set<String> nestedObjectsPaths = new LinkedHashSet<String>();
    private final List<LuceneIndexModel> models = new ArrayList<LuceneIndexModel>();

    LuceneDocumentTreeProjection(LuceneSearchIndexScopeImpl<?> scope) {
        super(scope);
        for (LuceneScopeIndexManagerContext index : scope.indexes()) {
            LuceneIndexModel model = index.model();
            this.models.add(model);
            if (!model.hasNestedDocuments()) continue;
            for (IndexFieldDescriptor field : ((LuceneIndexRoot)model.root()).staticChildren()) {
                LuceneDocumentTreeProjection.collect(this.nestedObjectsPaths, field);
            }
        }
    }

    private static void collect(Set<String> nestedPaths, IndexFieldDescriptor field) {
        if (field.isObjectField()) {
            if (field.toObjectField().type().nested()) {
                nestedPaths.add(field.absolutePath());
            }
            for (IndexFieldDescriptor child : field.toObjectField().staticChildren()) {
                LuceneDocumentTreeProjection.collect(nestedPaths, child);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public LuceneSearchProjection.Extractor<?, DocumentTree> request(ProjectionRequestContext context) {
        context.checkNotNested(LuceneProjectionTypeKeys.DOCUMENT, LuceneSearchHints.INSTANCE.documentProjectionNestingNotSupportedHint());
        context.requireAllStoredFields();
        context.requireNestedObjects(this.nestedObjectsPaths);
        return this;
    }

    @Override
    public Values<DocumentTree> values(ProjectionExtractContext context) {
        ArrayList<ChildDocumentTreeValues> children = new ArrayList<ChildDocumentTreeValues>();
        for (LuceneIndexModel model : this.models) {
            children.addAll(this.createChildrenDocumentTrees(context, (LuceneIndexCompositeNode)model.root()));
        }
        return new RootDocumentTreeValues(context.collectorExecutionContext().storedFieldsValuesDelegate(), children);
    }

    private List<ChildDocumentTreeValues> createChildrenDocumentTrees(ProjectionExtractContext context, LuceneIndexCompositeNode node) {
        ArrayList<ChildDocumentTreeValues> result = new ArrayList<ChildDocumentTreeValues>();
        for (LuceneIndexNode child : node.staticChildren()) {
            if (!child.isObjectField() || !((LuceneIndexCompositeNodeType)child.toObjectField().type()).nested()) continue;
            result.add(new ChildDocumentTreeValues(context.collectorExecutionContext(), node.nestedDocumentPath(), child.absolutePath(), this.createChildrenDocumentTrees(context, child.toObjectField())));
        }
        return result;
    }

    @Override
    public DocumentTree transform(LoadingResult<?> loadingResult, DocumentTree extractedData, ProjectionTransformContext context) {
        return extractedData;
    }

    private static class RootDocumentTreeValues
    implements Values<DocumentTree> {
        private final StoredFieldsValuesDelegate storedFieldsValuesDelegate;
        private final List<ChildDocumentTreeValues> children;

        private RootDocumentTreeValues(StoredFieldsValuesDelegate storedFieldsValuesDelegate, List<ChildDocumentTreeValues> children) {
            this.storedFieldsValuesDelegate = storedFieldsValuesDelegate;
            this.children = children;
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            for (ChildDocumentTreeValues child : this.children) {
                child.context(context);
            }
        }

        @Override
        public DocumentTree get(int doc) throws IOException {
            LinkedHashMap<String, Object> nested = new LinkedHashMap<String, Object>();
            for (ChildDocumentTreeValues child : this.children) {
                Object nodes = child.get(doc);
                if (nodes.isEmpty()) continue;
                nested.put(child.getPath(), nodes);
            }
            return new DocumentTreeImpl(this.storedFieldsValuesDelegate.get(doc), Collections.unmodifiableMap(nested));
        }
    }

    private static class ChildDocumentTreeValues
    implements Values<List<DocumentTree>> {
        private final StoredFieldsValuesDelegate storedFieldsValuesDelegate;
        private final String path;
        private final NestedDocsProvider nestedDocsProvider;
        private final List<ChildDocumentTreeValues> children;
        private ChildDocIds childDocIds;

        public ChildDocumentTreeValues(TopDocsDataCollectorExecutionContext context, String parent, String path, List<ChildDocumentTreeValues> children) {
            this.storedFieldsValuesDelegate = context.storedFieldsValuesDelegate();
            this.path = path;
            this.children = children;
            this.nestedDocsProvider = context.createNestedDocsProvider(parent, path);
        }

        @Override
        public void context(LeafReaderContext context) throws IOException {
            this.childDocIds = this.nestedDocsProvider.childDocs(context, null);
            for (ChildDocumentTreeValues child : this.children) {
                child.context(context);
            }
        }

        @Override
        public List<DocumentTree> get(int doc) throws IOException {
            ArrayList<DocumentTreeImpl> result = new ArrayList<DocumentTreeImpl>();
            if (this.childDocIds != null && this.childDocIds.advanceExactParent(doc)) {
                int currentChildDocId = this.childDocIds.nextChild();
                while (currentChildDocId != Integer.MAX_VALUE) {
                    LinkedHashMap<String, Object> nested = new LinkedHashMap<String, Object>();
                    for (ChildDocumentTreeValues child : this.children) {
                        Object nodes = child.get(currentChildDocId);
                        if (nodes.isEmpty()) continue;
                        nested.put(child.getPath().substring(this.path.length() + 1, child.path.length()), nodes);
                    }
                    result.add(new DocumentTreeImpl(this.storedFieldsValuesDelegate.get(currentChildDocId), Collections.unmodifiableMap(nested)));
                    currentChildDocId = this.childDocIds.nextChild();
                }
            }
            return Collections.unmodifiableList(result);
        }

        public String getPath() {
            return this.path;
        }
    }

    private static class DocumentTreeImpl
    implements DocumentTree {
        private final Document document;
        private final Map<String, Collection<DocumentTree>> nested;

        private DocumentTreeImpl(Document document, Map<String, Collection<DocumentTree>> nested) {
            this.document = document;
            this.nested = nested;
        }

        @Override
        public Document document() {
            return this.document;
        }

        @Override
        public Map<String, Collection<DocumentTree>> nested() {
            return this.nested;
        }

        public String toString() {
            return "DocumentTree{document=" + String.valueOf(this.document) + ", nested=" + String.valueOf(this.nested) + "}";
        }
    }
}

