/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.impl.CollectionHelper;

public interface LuceneSearchSort
extends SearchSort {
    public Set<String> indexNames();

    public void toSortFields(LuceneSearchSortCollector var1);

    public static LuceneSearchSort from(LuceneSearchIndexScope<?> scope, SearchSort sort) {
        if (!(sort instanceof LuceneSearchSort)) {
            throw QueryLog.INSTANCE.cannotMixLuceneSearchSortWithOtherSorts(sort);
        }
        LuceneSearchSort casted = (LuceneSearchSort)sort;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw QueryLog.INSTANCE.sortDefinedOnDifferentIndexes(sort, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }
}

