/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWorkExecutionContext;

public class DeleteEntriesByQueryWork
implements IndexManagementWork<Long> {
    private final Query query;

    DeleteEntriesByQueryWork(Query query) {
        this.query = query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("query=").append(this.query).append("]");
        return sb.toString();
    }

    @Override
    public Long execute(IndexManagementWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexAccessor().getIndexWriterDelegator();
            return indexWriterDelegator.deleteDocuments(this.query);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.unableToDeleteAllEntriesFromIndex(this.query, e.getMessage(), context.getEventContext(), e);
        }
    }

    @Override
    public Object getInfo() {
        return this;
    }
}

