/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Iterator;
import org.hibernate.Transaction;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.type.Type;

public interface Interceptor {
    default public boolean onLoad(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        return false;
    }

    default public boolean onPersist(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        return this.onSave(entity, id, state, propertyNames, types);
    }

    default public void onRemove(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        this.onDelete(entity, id, state, propertyNames, types);
    }

    default public boolean onFlushDirty(Object entity, Object id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return false;
    }

    @Deprecated(since="6.6")
    default public boolean onSave(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
        return false;
    }

    @Deprecated(since="6.6")
    default public void onDelete(Object entity, Object id, Object[] state, String[] propertyNames, Type[] types) {
    }

    default public void onCollectionRecreate(Object collection, Object key) {
    }

    default public void onCollectionRemove(Object collection, Object key) {
    }

    default public void onCollectionUpdate(Object collection, Object key) {
    }

    default public void preFlush(Iterator<Object> entities) {
    }

    default public void postFlush(Iterator<Object> entities) {
    }

    default public Boolean isTransient(Object entity) {
        return null;
    }

    default public int[] findDirty(Object entity, Object id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return null;
    }

    default public Object instantiate(String entityName, EntityRepresentationStrategy representationStrategy, Object id) {
        return this.instantiate(entityName, representationStrategy.getMode(), id);
    }

    default public Object instantiate(String entityName, RepresentationMode representationMode, Object id) {
        return null;
    }

    default public String getEntityName(Object object) {
        return null;
    }

    default public Object getEntity(String entityName, Object id) {
        return null;
    }

    default public void afterTransactionBegin(Transaction tx) {
    }

    default public void beforeTransactionCompletion(Transaction tx) {
    }

    default public void afterTransactionCompletion(Transaction tx) {
    }

    default public void onInsert(Object entity, Object id, Object[] state, String[] propertyNames, Type[] propertyTypes) {
    }

    default public void onUpdate(Object entity, Object id, Object[] state, String[] propertyNames, Type[] propertyTypes) {
    }

    default public void onUpsert(Object entity, Object id, Object[] state, String[] propertyNames, Type[] propertyTypes) {
    }

    default public void onDelete(Object entity, Object id, String[] propertyNames, Type[] propertyTypes) {
    }
}

