/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.Remove;
import org.hibernate.Timeouts;

@Deprecated(since="7", forRemoval=true)
public class LockOptions
implements Serializable {
    private final boolean immutable;
    private LockMode lockMode;
    private Timeout timeout;
    private PessimisticLockScope pessimisticLockScope;
    private Boolean followOnLocking;
    private Map<String, LockMode> aliasSpecificLockModes;
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions NONE = new LockOptions(true, LockMode.NONE);
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions READ = new LockOptions(true, LockMode.READ);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions OPTIMISTIC = new LockOptions(true, LockMode.OPTIMISTIC);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions OPTIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.OPTIMISTIC_FORCE_INCREMENT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_READ = new LockOptions(true, LockMode.PESSIMISTIC_READ);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_WRITE = new LockOptions(true, LockMode.PESSIMISTIC_WRITE);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions PESSIMISTIC_FORCE_INCREMENT = new LockOptions(true, LockMode.PESSIMISTIC_FORCE_INCREMENT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions UPGRADE_NOWAIT = new LockOptions(true, LockMode.UPGRADE_NOWAIT);
    @Deprecated(since="7", forRemoval=true)
    static final LockOptions UPGRADE_SKIPLOCKED = new LockOptions(true, LockMode.UPGRADE_SKIPLOCKED);
    @Deprecated(since="7", forRemoval=true)
    public static final LockOptions UPGRADE = PESSIMISTIC_WRITE;
    @Deprecated(since="7", forRemoval=true)
    public static final int NO_WAIT = 0;
    @Deprecated(since="7", forRemoval=true)
    public static final int WAIT_FOREVER = -1;
    @Deprecated(since="6.2", forRemoval=true)
    public static final int SKIP_LOCKED = -2;

    public LockOptions() {
        this.immutable = false;
        this.lockMode = LockMode.NONE;
        this.timeout = Timeouts.WAIT_FOREVER;
        this.pessimisticLockScope = PessimisticLockScope.NORMAL;
    }

    public LockOptions(LockMode lockMode) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = Timeouts.WAIT_FOREVER;
        this.pessimisticLockScope = PessimisticLockScope.NORMAL;
    }

    public LockOptions(LockMode lockMode, Timeout timeout) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout;
        this.pessimisticLockScope = PessimisticLockScope.NORMAL;
    }

    public LockOptions(LockMode lockMode, Timeout timeout, PessimisticLockScope scope) {
        this.immutable = false;
        this.lockMode = lockMode;
        this.timeout = timeout;
        this.pessimisticLockScope = scope;
    }

    protected LockOptions(boolean immutable, LockMode lockMode) {
        this.immutable = immutable;
        this.lockMode = lockMode;
        this.timeout = Timeouts.WAIT_FOREVER;
        this.pessimisticLockScope = PessimisticLockScope.NORMAL;
    }

    @Deprecated(since="7.0")
    public LockOptions(LockMode lockMode, int timeout) {
        this(lockMode, Timeouts.interpretMilliSeconds(timeout));
    }

    @Deprecated(since="7.0")
    public LockOptions(LockMode lockMode, int timeout, PessimisticLockScope scope) {
        this(lockMode, Timeouts.interpretMilliSeconds(timeout), scope);
    }

    public boolean isEmpty() {
        return this.lockMode == LockMode.NONE && this.timeout == Timeouts.WAIT_FOREVER && this.followOnLocking == null && this.pessimisticLockScope == PessimisticLockScope.NORMAL && !this.hasAliasSpecificLockModes();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        this.lockMode = lockMode;
        return this;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public LockOptions setTimeout(Timeout timeout) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockMode");
        }
        this.timeout = timeout;
        return this;
    }

    public int getTimeOut() {
        return this.getTimeout().milliseconds();
    }

    public LockOptions setTimeOut(int timeout) {
        return this.setTimeout(Timeouts.interpretMilliSeconds(timeout));
    }

    public PessimisticLockScope getLockScope() {
        return this.pessimisticLockScope;
    }

    public LockOptions setLockScope(PessimisticLockScope scope) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        this.pessimisticLockScope = scope;
        return this;
    }

    public Boolean getFollowOnLocking() {
        return this.followOnLocking;
    }

    public LockOptions setFollowOnLocking(Boolean followOnLocking) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        this.followOnLocking = followOnLocking;
        return this;
    }

    public LockOptions makeCopy() {
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    public LockOptions makeDefensiveCopy() {
        if (this.immutable) {
            return this;
        }
        LockOptions copy = new LockOptions();
        LockOptions.copy(this, copy);
        return copy;
    }

    public void overlay(LockOptions lockOptions) {
        this.setLockMode(lockOptions.getLockMode());
        this.setLockScope(lockOptions.getLockScope());
        this.setTimeOut(lockOptions.getTimeOut());
        if (lockOptions.aliasSpecificLockModes != null) {
            lockOptions.aliasSpecificLockModes.forEach(this::setAliasSpecificLockMode);
        }
        this.setFollowOnLocking(lockOptions.getFollowOnLocking());
    }

    public static LockOptions copy(LockOptions source, LockOptions destination) {
        destination.setLockMode(source.getLockMode());
        destination.setLockScope(source.getLockScope());
        destination.setTimeOut(source.getTimeOut());
        if (source.aliasSpecificLockModes != null) {
            destination.aliasSpecificLockModes = new HashMap<String, LockMode>(source.aliasSpecificLockModes);
        }
        destination.setFollowOnLocking(source.getFollowOnLocking());
        return destination;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LockOptions)) {
            return false;
        }
        LockOptions that = (LockOptions)object;
        return this.timeout == that.timeout && this.pessimisticLockScope == that.pessimisticLockScope && this.lockMode == that.lockMode && Objects.equals(this.aliasSpecificLockModes, that.aliasSpecificLockModes) && Objects.equals(this.followOnLocking, that.followOnLocking);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lockMode, this.timeout, this.aliasSpecificLockModes, this.followOnLocking, this.pessimisticLockScope});
    }

    @Remove
    public Set<Map.Entry<String, LockMode>> getAliasSpecificLocks() {
        return this.aliasSpecificLockModes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.aliasSpecificLockModes.entrySet());
    }

    @Remove
    public LockOptions setAliasSpecificLockMode(String alias, LockMode lockMode) {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable global instance of LockOptions");
        }
        if (this.aliasSpecificLockModes == null) {
            this.aliasSpecificLockModes = new LinkedHashMap<String, LockMode>();
        }
        if (lockMode == null) {
            this.aliasSpecificLockModes.remove(alias);
        } else {
            this.aliasSpecificLockModes.put(alias, lockMode);
        }
        return this;
    }

    @Remove
    public int getAliasLockCount() {
        return this.aliasSpecificLockModes == null ? 0 : this.aliasSpecificLockModes.size();
    }

    @Remove
    public boolean hasAliasSpecificLockModes() {
        return this.aliasSpecificLockModes != null && !this.aliasSpecificLockModes.isEmpty();
    }

    @Remove
    public LockMode getAliasSpecificLockMode(String alias) {
        return this.aliasSpecificLockModes == null ? null : this.aliasSpecificLockModes.get(alias);
    }

    @Deprecated
    public Iterator<Map.Entry<String, LockMode>> getAliasLockIterator() {
        return this.getAliasSpecificLocks().iterator();
    }

    @Remove
    public LockMode getEffectiveLockMode(String alias) {
        LockMode lockMode = this.getAliasSpecificLockMode(alias);
        if (lockMode == null) {
            lockMode = this.lockMode;
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    @Remove
    public LockMode findGreatestLockMode() {
        LockMode lockModeToUse = this.getLockMode();
        if (lockModeToUse == null) {
            lockModeToUse = LockMode.NONE;
        }
        if (this.aliasSpecificLockModes == null) {
            return lockModeToUse;
        }
        for (LockMode lockMode : this.aliasSpecificLockModes.values()) {
            if (!lockMode.greaterThan(lockModeToUse)) continue;
            lockModeToUse = lockMode;
        }
        return lockModeToUse;
    }
}

